/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;
import jgnash.engine.AccountGroup;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageListener;
import jgnash.text.CommodityFormat;
import jgnash.ui.budget.BudgetPeriodModel;
import jgnash.ui.budget.BudgetResultsTable;
import jgnash.ui.components.ShadowBorder;
import jgnash.ui.util.JTableUtils;
import org.jdesktop.swingx.JXTitledPanel;

final class BudgetPeriodPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JXTitledPanel periodHeader;
    private JPanel periodFooter;
    private JTable table;
    private JTable footerTable;
    private BudgetPeriodModel model;

    public BudgetPeriodPanel(BudgetPeriodModel model) {
        this.model = model;
        this.layoutMainPanel();
    }

    boolean isBetween(Date date) {
        return this.model.isBetween(date);
    }

    protected void setRowHeight(int rowHeight) {
        this.table.setRowHeight(rowHeight);
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("d:g", "d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.setLayout((LayoutManager)layout);
        NumberFormat format = CommodityFormat.getShortNumberFormat(this.model.getCurrency());
        this.table = new BudgetResultsTable((TableModel)this.model, format);
        this.table.setAutoResizeMode(0);
        this.table.setFocusable(false);
        this.table.setCellSelectionEnabled(false);
        JTableHeader header = new JTableHeader(this.table.getColumnModel());
        header.setReorderingAllowed(false);
        header.setResizingAllowed(false);
        header.setTable(this.table);
        this.buildHeader(header);
        this.buildFooter();
        JTableUtils.packTables(this.table, this.footerTable);
        builder.add((Component)this.table, CC.xy((int)1, (int)1));
        this.setBorder(ShadowBorder.getCompondShadowBorder());
        ToolTipManager.sharedInstance().unregisterComponent(this.table);
        ToolTipManager.sharedInstance().unregisterComponent(header);
    }

    public JComponent getPeriodHeader() {
        return this.periodHeader;
    }

    private void buildHeader(JTableHeader header) {
        this.periodHeader = new JXTitledPanel(this.model.getPeriodDescription(), (Container)header);
        this.periodHeader.setBorder(ShadowBorder.getCompondShadowBorder());
    }

    private void buildFooter() {
        FormLayout layout = new FormLayout("d:g", "d");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, new JPanel());
        NumberFormat format = CommodityFormat.getShortNumberFormat(EngineFactory.getEngine("default").getDefaultCurrency());
        this.footerTable = new BudgetResultsTable((TableModel)new FooterModel(), format);
        this.footerTable.setAutoResizeMode(0);
        this.footerTable.setFocusable(false);
        this.footerTable.setCellSelectionEnabled(false);
        builder.add((Component)this.footerTable, CC.xy((int)1, (int)1));
        builder.setBorder(ShadowBorder.getCompondShadowBorder());
        this.periodFooter = builder.getPanel();
    }

    public JComponent getPeriodFooter() {
        return this.periodFooter;
    }

    private class FooterModel
    extends AbstractTableModel
    implements MessageListener {
        private List<AccountGroup> groups;

        FooterModel() {
            this.groups = BudgetPeriodPanel.this.model.getExpandingBudgetTableModel().getAccountGroups();
            this.registerListeners();
        }

        private void registerListeners() {
            BudgetPeriodPanel.this.model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent e) {
                    FooterModel.this.fireTableDataChanged();
                }
            });
            BudgetPeriodPanel.this.model.addMessageListener(this);
        }

        @Override
        public int getRowCount() {
            return this.groups.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return BigDecimal.class;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.getTotalBudgeted(this.groups.get(rowIndex));
                }
                case 1: {
                    return this.getTotalChange(this.groups.get(rowIndex));
                }
                case 2: {
                    return this.getTotalRemaining(this.groups.get(rowIndex));
                }
            }
            return BigDecimal.ZERO;
        }

        protected BigDecimal getTotalRemaining(AccountGroup group) {
            return BudgetPeriodPanel.this.model.getRemainingTotal(group);
        }

        protected BigDecimal getTotalChange(AccountGroup group) {
            return BudgetPeriodPanel.this.model.getChangeTotal(group);
        }

        protected BigDecimal getTotalBudgeted(AccountGroup group) {
            return BudgetPeriodPanel.this.model.getBudgetedTotal(group);
        }

        @Override
        public void messagePosted(Message event) {
            switch (event.getEvent()) {
                case ACCOUNT_ADD: 
                case ACCOUNT_REMOVE: 
                case ACCOUNT_MODIFY: 
                case BUDGET_UPDATE: {
                    this.groups = BudgetPeriodPanel.this.model.getExpandingBudgetTableModel().getAccountGroups();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            FooterModel.this.fireTableDataChanged();
                            JTableUtils.packTables(BudgetPeriodPanel.this.table, BudgetPeriodPanel.this.footerTable);
                        }
                    });
                }
            }
        }
    }
}

