/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.checks;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import jgnash.engine.Transaction;
import jgnash.engine.checks.CheckLayout;
import jgnash.engine.checks.CheckObject;
import jgnash.text.BigDecimalToWords;

class PrintableCheckLayout
implements Printable {
    private CheckLayout checkLayout;
    private Transaction[] transactions;
    private PageFormat pageFormat;
    private boolean testPrint = false;
    private Font font;
    private Font testPrintFont;
    private FontRenderContext frc;
    private PrinterJob job = PrinterJob.getPrinterJob();
    private static float space = 4.5f;

    protected PrintableCheckLayout(CheckLayout layout) {
        this.checkLayout = layout;
        this.pageFormat = this.getPrinterJob().defaultPage();
    }

    public void setCheckLayout(CheckLayout layout) {
        this.checkLayout = layout;
    }

    public CheckLayout getCheckLayout() {
        return this.checkLayout;
    }

    private PrinterJob getPrinterJob() {
        if (this.job == null) {
            this.job = PrinterJob.getPrinterJob();
        }
        return this.job;
    }

    protected PageFormat pageSetup() {
        this.pageFormat = this.getPrinterJob().pageDialog(this.checkLayout.getPrintAttributes());
        return this.pageFormat;
    }

    protected void print() {
        this.getPrinterJob().setPrintable(this);
        if (this.getPrinterJob().printDialog(this.checkLayout.getPrintAttributes())) {
            try {
                this.getPrinterJob().print(this.checkLayout.getPrintAttributes());
            }
            catch (PrinterException pe) {
                Logger.getLogger(PrintableCheckLayout.class.getName()).log(Level.SEVERE, null, pe);
            }
        }
    }

    protected void print(Transaction[] t) {
        assert (t != null);
        assert (t.length == this.checkLayout.getNumberOfChecks());
        this.transactions = t;
        this.print();
    }

    public CheckObject[] getCheckObjects() {
        List<CheckObject> checkObjects = this.checkLayout.getCheckObjects();
        return checkObjects.toArray(new CheckObject[checkObjects.size()]);
    }

    public double getCheckHeight() {
        return this.checkLayout.getCheckHeight();
    }

    public void setNumChecks(int count) {
        this.checkLayout.setNumberOfChecks(count);
    }

    public int getNumChecks() {
        return this.checkLayout.getNumberOfChecks();
    }

    public PageFormat getPageFormat() {
        PrintRequestAttributeSet attrs = this.checkLayout.getPrintAttributes();
        if (this.pageFormat == null) {
            PageFormat format = this.getPrinterJob().defaultPage();
            Paper paper = format.getPaper();
            MediaSizeName media = (MediaSizeName)attrs.get(Media.class);
            MediaSize ms = MediaSize.getMediaSizeForName(media);
            MediaPrintableArea ma = (MediaPrintableArea)attrs.get(MediaPrintableArea.class);
            if (ma != null) {
                int INCH = 25400;
                paper.setImageableArea(ma.getX(INCH) * 72.0f, ma.getY(INCH) * 72.0f, ma.getWidth(INCH) * 72.0f, ma.getHeight(INCH) * 72.0f);
            }
            if (ms != null) {
                paper.setSize(ms.getX(25400) * 72.0f, ms.getY(25400) * 72.0f);
            }
            format.setPaper(paper);
            OrientationRequested or = (OrientationRequested)attrs.get(OrientationRequested.class);
            if (or != null) {
                if (or == OrientationRequested.LANDSCAPE) {
                    format.setOrientation(0);
                } else if (or == OrientationRequested.REVERSE_LANDSCAPE) {
                    format.setOrientation(2);
                } else if (or == OrientationRequested.PORTRAIT) {
                    format.setOrientation(1);
                } else if (or == OrientationRequested.REVERSE_PORTRAIT) {
                    format.setOrientation(1);
                }
            }
            this.pageFormat = format;
        }
        return this.pageFormat;
    }

    public void setTestPrint(boolean testPrint) {
        this.testPrint = testPrint;
    }

    private void drawCheck(Graphics2D g2, Rectangle2D bounds, BigDecimal amount, Date date, String memo, String payee) {
        this.font = new Font("Serif", 0, 10);
        this.testPrintFont = new Font("Serif", 1, 9);
        float offset = (float)bounds.getY();
        this.frc = g2.getFontRenderContext();
        if (this.testPrint) {
            g2.draw(bounds);
        }
        for (CheckObject o : this.checkLayout.getCheckObjects()) {
            switch (o.getType()) {
                case ADDRESS: 
                case AMOUNT: {
                    this.drawAmount(g2, o, offset, amount);
                    break;
                }
                case AMOUNT_TEXT: {
                    this.drawAmountText(g2, o, offset, amount);
                    break;
                }
                case DATE: {
                    this.drawDate(g2, o, offset, date);
                    break;
                }
                case MEMO: {
                    this.drawMemo(g2, o, offset, memo);
                    break;
                }
                case PAYEE: {
                    this.drawPayee(g2, o, offset, payee);
                    break;
                }
            }
        }
    }

    private void drawSheet(Graphics2D g2, PageFormat format, Transaction[] list) {
        double checkHeight = this.checkLayout.getCheckHeight();
        int numChecks = this.checkLayout.getNumberOfChecks();
        for (int i = 0; i < numChecks; ++i) {
            Date date;
            BigDecimal amount;
            String memo;
            String payee;
            Rectangle2D.Double bounds = new Rectangle2D.Double(0.0, (double)i * checkHeight, format.getWidth(), checkHeight);
            if (list != null) {
                if (list.length != this.getNumChecks()) {
                    return;
                }
                if (list[i] == null) continue;
                payee = list[i].getPayee();
                memo = list[i].getMemo();
                amount = list[i].getAmount(list[i].getCommonAccount()).abs();
                date = list[i].getDate();
                this.drawCheck(g2, bounds, amount, date, memo, payee);
                continue;
            }
            payee = "Expensive bank USA";
            memo = "I spent too much on the widget";
            amount = new BigDecimal("12345.67");
            date = new Date();
            this.drawCheck(g2, bounds, amount, date, memo, payee);
        }
    }

    private void drawDate(Graphics2D g2, CheckObject object, float offset, Date date) {
        DateFormat df = DateFormat.getDateInstance(3);
        float dateX = object.getX();
        float dateY = object.getY() + offset;
        TextLayout tdate = new TextLayout(df.format(date), this.font, this.frc);
        tdate.draw(g2, dateX, dateY);
        if (this.testPrint) {
            TextLayout dateText = new TextLayout("DATE", this.testPrintFont, this.frc);
            double width = dateText.getBounds().getWidth();
            dateText.draw(g2, (float)((double)dateX - width - (double)space), dateY);
        }
    }

    private void drawMemo(Graphics2D g2, CheckObject object, float offset, String memo) {
        TextLayout text;
        float x = object.getX();
        float y = object.getY() + offset;
        if (memo != null && memo.length() > 0) {
            text = new TextLayout(memo, this.font, this.frc);
            text.draw(g2, x, y);
        }
        if (this.testPrint) {
            text = new TextLayout("MEMO", this.testPrintFont, this.frc);
            double width = text.getBounds().getWidth();
            text.draw(g2, (float)((double)x - width - (double)space), y);
        }
    }

    private void drawAmount(Graphics2D g2, CheckObject object, float offset, BigDecimal amount) {
        float x = object.getX();
        float y = object.getY() + offset;
        TextLayout text = new TextLayout("**" + amount.toString() + "**", this.font, this.frc);
        text.draw(g2, x, y);
        if (this.testPrint) {
            text = new TextLayout("$", this.testPrintFont, this.frc);
            double width = text.getBounds().getWidth();
            text.draw(g2, (float)((double)x - width - (double)space), y);
        }
    }

    private void drawAmountText(Graphics2D g2, CheckObject object, float offset, BigDecimal amount) {
        String amountText = BigDecimalToWords.convert(amount);
        float x = object.getX();
        float y = object.getY() + offset;
        TextLayout text = new TextLayout(amountText, this.font, this.frc);
        text.draw(g2, x, y);
    }

    private void drawPayee(Graphics2D g2, CheckObject object, float offset, String payee) {
        float payeeX = object.getX();
        float payeeY = object.getY() + offset;
        if (payee != null && payee.length() > 0) {
            TextLayout tpayee = new TextLayout(payee, this.font, this.frc);
            tpayee.draw(g2, payeeX, payeeY);
        }
        if (this.testPrint) {
            TextLayout payeeText = new TextLayout("ORDER OF", this.testPrintFont, this.frc);
            double width = payeeText.getBounds().getWidth();
            payeeText.draw(g2, (float)((double)payeeX - width - (double)space), payeeY);
            LineMetrics metrics = this.testPrintFont.getLineMetrics("PAY TO THE", this.frc);
            float y = payeeY - (float)payeeText.getBounds().getHeight() - metrics.getDescent() - metrics.getLeading();
            payeeText = new TextLayout("PAY TO THE", this.testPrintFont, this.frc);
            payeeText.draw(g2, (float)((double)payeeX - width - (double)space), y);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pf, int pageIndex) {
        if (pageIndex == 0) {
            Graphics2D g2 = (Graphics2D)graphics;
            if (g2.getDeviceConfiguration().getDevice().getType() == 1) {
                g2.translate(pf.getImageableX(), pf.getImageableY());
            }
            this.drawSheet(g2, pf, this.transactions);
            return 0;
        }
        return 1;
    }
}

