/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.commodity;

import com.jgoodies.forms.builder.ButtonBarBuilder2;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.QuoteSource;
import jgnash.engine.SecurityNode;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.components.CurrencyComboBox;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.components.JIntegerField;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.QuoteSourceComboBox;
import jgnash.ui.components.SortedListModel;
import jgnash.util.Resource;

public class SecurityModifyPanel
extends JPanel
implements MessageListener,
ActionListener {
    private final Engine engine = EngineFactory.getEngine("default");
    private final Resource rb = Resource.get();
    private JButton newButton;
    private JList<SecurityNode> securityList;
    private JButton deleteButton;
    private JTextField symbolField;
    private JTextField isinField;
    private JTextField descriptionField;
    private JTextField scaleField;
    private JButton cancelButton;
    private JButton applyButton;
    private SortedListModel<SecurityNode> model;
    private CurrencyComboBox currencyCombo;
    private QuoteSourceComboBox sourceComboBox;
    private boolean isModifying = false;

    public static void showDialog(final JFrame parent) {
        final Resource rb = Resource.get();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                GenericCloseDialog d = new GenericCloseDialog((Window)parent, new SecurityModifyPanel(), rb.getString("Title.CreateModifyCommodities"));
                d.setMinimumSize(d.getSize());
                d.setLocationRelativeTo(parent);
                d.setVisible(true);
            }
        });
    }

    private SecurityModifyPanel() {
        this.layoutMainPanel();
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
    }

    private void initComponents() {
        this.securityList = new JList();
        this.securityList.setSelectionMode(0);
        this.symbolField = new JTextFieldEx();
        this.descriptionField = new JTextFieldEx();
        this.scaleField = new JIntegerField();
        this.scaleField.setToolTipText(this.rb.getString("ToolTip.Scale"));
        this.isinField = new JTextFieldEx();
        this.isinField.setToolTipText(this.rb.getString("ToolTip.ISIN"));
        this.sourceComboBox = new QuoteSourceComboBox();
        this.currencyCombo = new CurrencyComboBox();
        this.currencyCombo.setSelectedNode(EngineFactory.getEngine("default").getDefaultCurrency());
        this.newButton = new JButton(this.rb.getString("Button.New"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.applyButton = new JButton(this.rb.getString("Button.Apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.buildLists();
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p:g, 8dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.CommoditiesSecurities"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"fill:p:g"));
        builder.append((Component)new JScrollPane(this.securityList), (Component)this.layoutRightPanel());
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.layoutButtonPanel(), 3);
    }

    private JPanel layoutRightPanel() {
        FormLayout layout = new FormLayout("right:p, $lcgap, 90dlu", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.Symbol"), (Component)this.symbolField);
        builder.append(this.rb.getString("Label.ISIN"), (Component)this.isinField);
        builder.append(this.rb.getString("Label.QuoteSource"), (Component)this.sourceComboBox);
        builder.append(this.rb.getString("Label.Description"), (Component)this.descriptionField);
        builder.append(this.rb.getString("Label.Scale"), (Component)this.scaleField);
        builder.append(this.rb.getString("Label.ReportedCurrency"), (Component)this.currencyCombo);
        return builder.getPanel();
    }

    private JPanel layoutButtonPanel() {
        ButtonBarBuilder2 builder = new ButtonBarBuilder2();
        builder.addButton((JComponent[])new JButton[]{this.newButton, this.deleteButton, this.cancelButton});
        builder.addUnrelatedGap();
        builder.addGlue();
        builder.addButton((JComponent)this.applyButton);
        return builder.getPanel();
    }

    private void buildLists() {
        this.model = new SortedListModel<SecurityNode>(this.engine.getSecurities());
        ListListener listener = new ListListener();
        this.securityList.setModel(this.model);
        this.securityList.addListSelectionListener(listener);
    }

    void updateForm() {
        SecurityNode node = this.securityList.getSelectedValue();
        if (node != null) {
            this.symbolField.setText(node.getSymbol());
            this.isinField.setText(node.getISIN());
            this.descriptionField.setText(node.getDescription());
            this.scaleField.setText(Short.toString(node.getScale()));
            this.currencyCombo.setSelectedNode(node.getReportedCurrencyNode());
            this.sourceComboBox.setSelectedItem((Object)node.getQuoteSource());
            this.isModifying = true;
        }
    }

    private void clearForm() {
        this.securityList.clearSelection();
        this.symbolField.setText(null);
        this.isinField.setText(null);
        this.descriptionField.setText(null);
        this.scaleField.setText(null);
        this.currencyCombo.setSelectedNode(EngineFactory.getEngine("default").getDefaultCurrency());
        this.isModifying = false;
    }

    private boolean validateForm() {
        if (this.scaleField.getText().equals("")) {
            this.scaleField.setText("2");
        }
        if (this.symbolField.getText().equals("")) {
            return false;
        }
        return this.currencyCombo.getSelectedNode() != null;
    }

    private SecurityNode buildSecurityNode() {
        SecurityNode node = new SecurityNode((CurrencyNode)this.currencyCombo.getSelectedNode());
        node.setDescription(this.descriptionField.getText());
        node.setScale(Byte.parseByte(this.scaleField.getText()));
        node.setSymbol(this.symbolField.getText().trim());
        node.setISIN(this.isinField.getText().trim());
        node.setQuoteSource((QuoteSource)((Object)this.sourceComboBox.getSelectedItem()));
        return node;
    }

    private void commitSecurityNode() {
        SecurityNode oldNode = this.securityList.getSelectedValue();
        if (this.validateForm()) {
            SecurityNode newNode = this.buildSecurityNode();
            if (this.isModifying && oldNode != null) {
                this.engine.updateCommodity(oldNode, newNode);
            } else {
                this.engine.addCommodity(newNode);
            }
        }
    }

    private void deleteSecurityNode() {
        SecurityNode node = this.securityList.getSelectedValue();
        if (node != null && !this.engine.removeCommodity(node)) {
            throw new RuntimeException("Unable to remove the security");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.commitSecurityNode();
        } else if (e.getSource() == this.cancelButton) {
            this.clearForm();
        } else if (e.getSource() == this.deleteButton) {
            this.deleteSecurityNode();
        } else if (e.getSource() == this.newButton) {
            this.clearForm();
        }
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getObject(MessageProperty.COMMODITY) instanceof SecurityNode) {
            final SecurityNode node = (SecurityNode)event.getObject(MessageProperty.COMMODITY);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case CURRENCY_REMOVE: {
                            SecurityModifyPanel.this.model.removeElement(node);
                            SecurityModifyPanel.this.clearForm();
                            break;
                        }
                        case CURRENCY_REMOVE_FAILED: {
                            String message = "Commodity " + node.toString() + " cannot be removed";
                            JOptionPane.showMessageDialog(SecurityModifyPanel.this, message, SecurityModifyPanel.this.rb.getString("Message.WarnCommodityInUse"), 2);
                            break;
                        }
                        case CURRENCY_ADD: {
                            SecurityModifyPanel.this.clearForm();
                            SecurityModifyPanel.this.model.addElement(node);
                            break;
                        }
                        case CURRENCY_ADD_FAILED: {
                            JOptionPane.showMessageDialog(SecurityModifyPanel.this, SecurityModifyPanel.this.rb.getString("Message.ErrorAddCommodity"), SecurityModifyPanel.this.rb.getString("Title.Error"), 0);
                            break;
                        }
                        case CURRENCY_MODIFY: {
                            SecurityModifyPanel.this.clearForm();
                            SecurityModifyPanel.this.model.removeElement(node);
                            SecurityModifyPanel.this.model.addElement(node);
                            SecurityModifyPanel.this.model.fireContentsChanged();
                            break;
                        }
                        case CURRENCY_MODIFY_FAILED: {
                            JOptionPane.showMessageDialog(SecurityModifyPanel.this, SecurityModifyPanel.this.rb.getString("Message.ErrorModifyCommodity"), SecurityModifyPanel.this.rb.getString("Title.Error"), 0);
                            break;
                        }
                    }
                }
            });
        }
    }

    private class ListListener
    implements ListSelectionListener {
        private ListListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting() && listSelectionEvent.getSource() == SecurityModifyPanel.this.securityList) {
                SecurityModifyPanel.this.updateForm();
            }
        }
    }
}

