/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import jgnash.engine.CommodityNode;
import jgnash.engine.CurrencyNode;
import jgnash.engine.EngineFactory;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;
import jgnash.ui.components.AbstractCommodityComboBox;

public class CurrencyComboBox
extends AbstractCommodityComboBox<CurrencyNode> {
    public CurrencyComboBox() {
        SwingWorker<List<CurrencyNode>, Void> worker = new SwingWorker<List<CurrencyNode>, Void>(){
            CurrencyNode defaultNode;

            @Override
            public List<CurrencyNode> doInBackground() {
                this.defaultNode = EngineFactory.getEngine("default").getDefaultCurrency();
                return EngineFactory.getEngine("default").getCurrencies();
            }

            @Override
            public void done() {
                try {
                    CurrencyComboBox.this.model.addAll((Collection)this.get());
                    CurrencyComboBox.this.setSelectedNode(this.defaultNode);
                }
                catch (InterruptedException | ExecutionException e) {
                    Logger.getLogger(CurrencyComboBox.class.getName()).severe(e.getLocalizedMessage());
                }
            }
        };
        worker.execute();
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY);
    }

    public CurrencyComboBox(Collection<CurrencyNode> list) {
        this.model.addAll(list);
    }

    @Override
    public void messagePosted(final Message event) {
        final CommodityNode node = (CommodityNode)event.getObject(MessageProperty.COMMODITY);
        if (node instanceof CurrencyNode) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case CURRENCY_REMOVE: {
                            CurrencyComboBox.this.model.removeElement(node);
                            break;
                        }
                        case CURRENCY_ADD: {
                            CurrencyComboBox.this.model.addElement((CurrencyNode)node);
                            break;
                        }
                        case CURRENCY_MODIFY: {
                            CurrencyComboBox.this.updateNode((CurrencyNode)node);
                            break;
                        }
                    }
                }
            });
        }
    }
}

