/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import jgnash.ui.components.JTextFieldEx;
import jgnash.util.DateUtils;

public final class JDateField
extends JTextFieldEx {
    private final String DATE;
    private final DateFormat formatter = DateFormat.getDateInstance(3);

    public JDateField() {
        super(0);
        char[] chars;
        StringBuilder buf = new StringBuilder("0123456789");
        for (char aChar : chars = this.formatter.format(new Date()).toCharArray()) {
            if (Character.isDigit(aChar) || buf.indexOf(Character.toString(aChar)) != -1) continue;
            buf.append(aChar);
        }
        this.DATE = buf.toString();
        this.setInputVerifier(new DateVerifier());
        this.setValue(new Date());
        this.addKeyListener(new KeySpinner());
    }

    public void setValue(Object value) {
        if (value instanceof Date) {
            this.setText(this.formatter.format((Date)value));
        } else {
            this.setText("");
        }
    }

    public Object getValue() {
        return this.dateValue();
    }

    public Date dateValue() {
        Date tDate = new Date();
        try {
            tDate.setTime(this.formatter.parse(this.getText()).getTime());
        }
        catch (ParseException e) {
            Logger.getLogger(JDateField.class.getName()).log(Level.INFO, e.getLocalizedMessage(), e);
        }
        return tDate;
    }

    @Override
    protected Document createDefaultModel() {
        return new DateDocument();
    }

    private final class KeySpinner
    extends KeyAdapter {
        private KeySpinner() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int pos = JDateField.this.getCaretPosition();
            switch (e.getKeyCode()) {
                case 38: 
                case 224: {
                    JDateField.this.setValue(DateUtils.addDay(JDateField.this.dateValue()));
                    break;
                }
                case 40: 
                case 225: {
                    JDateField.this.setValue(DateUtils.subtractDay(JDateField.this.dateValue()));
                    break;
                }
                case 33: {
                    JDateField.this.setValue(DateUtils.addMonth(JDateField.this.dateValue()));
                    break;
                }
                case 34: {
                    JDateField.this.setValue(DateUtils.subtractMonth(JDateField.this.dateValue()));
                    break;
                }
                case 84: {
                    JDateField.this.setValue(new Date());
                    break;
                }
                default: {
                    return;
                }
            }
            if (JDateField.this.getText().length() < pos) {
                JDateField.this.setCaretPosition(JDateField.this.getText().length());
            } else {
                JDateField.this.setCaretPosition(pos);
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
            int pos = JDateField.this.getCaretPosition();
            switch (e.getKeyChar()) {
                case '+': {
                    JDateField.this.setValue(DateUtils.addDay(JDateField.this.dateValue()));
                    break;
                }
                case '-': {
                    JDateField.this.setValue(DateUtils.subtractDay(JDateField.this.dateValue()));
                    break;
                }
                default: {
                    return;
                }
            }
            e.consume();
            if (pos < JDateField.this.getDocument().getLength()) {
                JDateField.this.setCaretPosition(pos);
            } else {
                JDateField.this.setCaretPosition(JDateField.this.getDocument().getLength());
            }
        }
    }

    private class DateVerifier
    extends InputVerifier {
        private DateVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            if (((JTextField)input).getText().length() == 0) {
                return true;
            }
            try {
                JDateField.this.formatter.parse(((JTextField)input).getText());
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }
    }

    class DateDocument
    extends PlainDocument {
        private static final long serialVersionUID = 7524547195996054009L;

        DateDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            if (str == null) {
                return;
            }
            for (int i = 0; i < str.length(); ++i) {
                if (JDateField.this.DATE.contains(String.valueOf(str.charAt(i)))) continue;
                return;
            }
            super.insertString(offs, str, a);
        }
    }
}

