/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.prefs.Preferences;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class JTextFieldEx
extends JTextField {
    private static final String SELECT_ON_FOCUS = "selectOnFocus";
    private static boolean select = false;

    public JTextFieldEx() {
        this.installFocusListener();
    }

    public JTextFieldEx(String text) {
        super(text);
        this.installFocusListener();
    }

    public JTextFieldEx(int columns) {
        super(columns);
        this.installFocusListener();
    }

    public JTextFieldEx(String text, int columns) {
        super(text, columns);
        this.installFocusListener();
    }

    public JTextFieldEx(Document doc, String text, int columns) {
        super(doc, text, columns);
        this.installFocusListener();
    }

    private void installFocusListener() {
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (JTextFieldEx.this.isEditable() && select) {
                            JTextFieldEx.this.selectAll();
                        }
                    }
                });
            }
        };
        this.addFocusListener(focusListener);
    }

    public static void setSelectOnFocus(boolean select) {
        Preferences p = Preferences.userNodeForPackage(JTextFieldEx.class);
        p.putBoolean(SELECT_ON_FOCUS, select);
        JTextFieldEx.select = select;
    }

    public static boolean isSelectOnFocus() {
        return select;
    }

    static {
        Preferences p = Preferences.userNodeForPackage(JTextFieldEx.class);
        select = p.getBoolean(SELECT_ON_FOCUS, false);
    }
}

