/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractListModel;

public class SortedListModel<E extends Comparable<? super E>>
extends AbstractListModel<E> {
    private static final long serialVersionUID = -5321417365496715895L;
    private final List<E> list = new ArrayList();

    public SortedListModel() {
    }

    public SortedListModel(Collection<E> list) {
        this.add(list);
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    @Override
    public E getElementAt(int index) {
        return (E)((Comparable)this.list.get(index));
    }

    public E get(int index) {
        return (E)((Comparable)this.list.get(index));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void add(Collection<E> aList) {
        List<E> list = this.list;
        synchronized (list) {
            this.list.addAll(aList);
            Collections.sort(this.list);
        }
    }

    public boolean contains(E elem) {
        return this.list.contains(elem);
    }

    int indexOf(E elem) {
        return this.list.indexOf(elem);
    }

    public void addElement(E obj) {
        int i = Collections.binarySearch(this.list, obj);
        if (i < 0) {
            int index = -i - 1;
            this.list.add(index, obj);
            this.fireIntervalAdded(this, index, index);
        }
    }

    public boolean removeElement(E obj) {
        int index = this.indexOf(obj);
        boolean rv = this.list.remove(obj);
        if (index >= 0) {
            this.fireIntervalRemoved(this, index, index);
        }
        return rv;
    }

    public Object[] toArray() {
        return this.list.toArray();
    }

    public List<E> asList() {
        return new ArrayList<E>(this.list);
    }

    public Object remove(int index) {
        E rv = this.list.get(index);
        this.list.remove(index);
        this.fireIntervalRemoved(this, index, index);
        return rv;
    }

    public void clear() {
        int index1 = this.list.size() - 1;
        this.list.clear();
        if (index1 >= 0) {
            this.fireIntervalRemoved(this, 0, index1);
        }
    }

    public void fireContentsChanged() {
        Collections.sort(this.list);
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }
}

