/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.option;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jgnash.ui.ThemeManager;
import jgnash.ui.UIApplication;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.register.TransactionNumberDialog;
import jgnash.util.Resource;

class GeneralOptions
extends JPanel
implements ActionListener {
    private final Resource rb = Resource.get();
    private JCheckBox animationsEnabled;
    private JButton numButton;
    private JDialog parent;
    private JCheckBox selectOnFocusCheckBox;
    private JSpinner nimbusFontSpinner;

    GeneralOptions(JDialog parent) {
        this.parent = parent;
        this.layoutMainPanel();
        this.showState();
        this.selectOnFocusCheckBox.addActionListener(this);
        this.numButton.addActionListener(this);
        this.animationsEnabled.addActionListener(this);
        this.nimbusFontSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int size = ((SpinnerNumberModel)GeneralOptions.this.nimbusFontSpinner.getModel()).getNumber().intValue();
                ThemeManager.setNimbusFontSize(size);
            }
        });
    }

    private void initComponents() {
        this.animationsEnabled = new JCheckBox(this.rb.getString("Button.SubstanceAnimations"));
        this.numButton = new JButton(this.rb.getString("Button.EditDefTranNums"));
        this.selectOnFocusCheckBox = new JCheckBox(this.rb.getString("Button.SelectText"));
        SpinnerNumberModel model = new SpinnerNumberModel(ThemeManager.getNimbusFontSize(), 9, 15, 1);
        this.nimbusFontSpinner = new JSpinner(model);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("right:p, $lcgap, max(75dlu;p):g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setRowGroupingEnabled(true);
        builder.setDefaultDialogBorder();
        builder.appendSeparator(this.rb.getString("Title.Display"));
        builder.append((Component)this.animationsEnabled, 3);
        builder.append(this.rb.getString("Label.NimbusFontSize"), (Component)this.nimbusFontSpinner);
        builder.appendSeparator(this.rb.getString("Title.Defaults"));
        builder.append((Component)this.numButton, 3);
        builder.appendSeparator(this.rb.getString("Title.Entry"));
        builder.append((Component)this.selectOnFocusCheckBox, 3);
    }

    private void showState() {
        this.selectOnFocusCheckBox.setSelected(JTextFieldEx.isSelectOnFocus());
        this.animationsEnabled.setSelected(ThemeManager.isSubstanceAnimationsEnabled());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.numButton) {
            this.defaultNumAction();
        } else if (e.getSource() == this.selectOnFocusCheckBox) {
            JTextFieldEx.setSelectOnFocus(this.selectOnFocusCheckBox.isSelected());
        } else if (e.getSource() == this.animationsEnabled) {
            ThemeManager.setSubstanceAnimationsEnabled(this.animationsEnabled.isSelected());
        }
    }

    private void defaultNumAction() {
        this.parent.setVisible(false);
        TransactionNumberDialog.showDialog(UIApplication.getFrame());
        this.parent.setVisible(true);
    }
}

