/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.reconcile;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.util.Date;
import javax.swing.JButton;
import javax.swing.JDialog;
import jgnash.engine.Account;
import jgnash.ui.UIApplication;
import jgnash.ui.components.DatePanel;
import jgnash.ui.components.JFloatField;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public class ReconcileSettingsDialog
extends JDialog
implements ActionListener {
    private final Resource rb = Resource.get();
    private final JButton okButton;
    private final JButton cancelButton;
    private final JFloatField openField = new JFloatField();
    private final JFloatField endField = new JFloatField();
    private final DatePanel datePanel = new DatePanel();
    private boolean returnValue = false;

    public ReconcileSettingsDialog(Account account) {
        super((Frame)UIApplication.getFrame(), true);
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.datePanel.setDate(account.getFirstUnreconciledTransactionDate());
        this.layoutMainPanel();
        this.setTitle(this.rb.getString("Title.ReconcileSettings"));
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.openField.setDecimal(AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getOpeningBalanceForReconcile()));
        this.endField.setDecimal(AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getBalance()));
        DialogUtils.addBoundsListener(this);
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("p:g, $lcgap, max(70dlu;min)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.OpenStateDate"), (Component)this.datePanel);
        builder.append(this.rb.getString("Label.OpeningBalance"), (Component)this.openField);
        builder.append(this.rb.getString("Label.EndingBalance"), (Component)this.endField);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
    }

    public BigDecimal getEndingBalance() {
        return this.endField.getDecimal();
    }

    public BigDecimal getOpeningBalance() {
        return this.openField.getDecimal();
    }

    public Date getOpeningDate() {
        return this.datePanel.getDate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.returnValue = e.getSource() == this.okButton;
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    public boolean showDialog() {
        this.setVisible(true);
        return this.returnValue;
    }
}

