/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.ui.register.RegisterEvent;
import jgnash.ui.register.RegisterListener;
import jgnash.ui.util.ValidationFactory;
import jgnash.util.Resource;

public abstract class AbstractEntryFormPanel
extends JPanel {
    protected final Resource rb = Resource.get();
    protected final KeyListener keyListener = new FormKeyListener();

    protected static final void showValidationError(String error, JComponent origin) {
        ValidationFactory.showValidationError(error, origin);
    }

    protected void add(String label, Object constraints) {
        this.add((Component)new JLabel(this.rb.getString(label)), constraints);
    }

    protected void focusFirstComponent() {
        Component c;
        if (this.getFocusTraversalPolicy() != null && (c = this.getFocusTraversalPolicy().getFirstComponent(this)) != null) {
            c.requestFocusInWindow();
        }
    }

    protected void addRegisterListener(RegisterListener l) {
        this.listenerList.add(RegisterListener.class, l);
    }

    protected void removeRegisterListener(RegisterListener l) {
        this.listenerList.remove(RegisterListener.class, l);
    }

    void fireCancelAction() {
        this.fireAction(RegisterEvent.Action.CANCEL);
    }

    void fireOkAction() {
        this.fireAction(RegisterEvent.Action.OK);
    }

    private void fireAction(RegisterEvent.Action action) {
        RegisterEvent e = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != RegisterListener.class) continue;
            if (e == null) {
                e = new RegisterEvent(this, action);
            }
            ((RegisterListener)listeners[i + 1]).registerEvent(e);
        }
    }

    public abstract void clearForm();

    protected abstract boolean validateForm();

    public abstract void enterAction();

    public abstract void modifyTransaction(Transaction var1);

    static Engine getEngine() {
        return EngineFactory.getEngine("default");
    }

    private class FormKeyListener
    extends KeyAdapter {
        private FormKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                if (AbstractEntryFormPanel.this.validateForm()) {
                    AbstractEntryFormPanel.this.enterAction();
                } else {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            } else if (e.getKeyCode() == 27) {
                AbstractEntryFormPanel.this.clearForm();
            }
        }
    }
}

