/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountProperty;
import jgnash.engine.AmortizeObject;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.ui.account.AmortizeDialog;
import jgnash.ui.register.DateChkNumberDialog;
import jgnash.ui.register.EditTransactionDialog;
import jgnash.ui.register.PanelType;
import jgnash.ui.register.RegisterPanel;

public class LiabilityRegisterPanel
extends RegisterPanel {
    private JButton amortizeButton;
    private JButton paymentButton;
    private Engine engine = EngineFactory.getEngine("default");

    LiabilityRegisterPanel(Account account) {
        super(account);
    }

    @Override
    protected void initComponents() {
        super.initComponents();
        this.paymentButton = new JButton(this.rb.getString("Button.NewPayment"));
        this.amortizeButton = new JButton(this.rb.getString("Button.Amortize"));
        this.amortizeButton.addActionListener(this);
        this.paymentButton.addActionListener(this);
    }

    @Override
    protected JPanel createButtonPanel() {
        FormLayout layout = new FormLayout("d, 4dlu:g, d", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)ButtonBarFactory.buildLeftAlignedBar((JButton[])new JButton[]{this.newButton, this.duplicateButton, this.jumpButton, this.deleteButton}));
        builder.append((Component)ButtonBarFactory.buildRightAlignedBar((JButton[])new JButton[]{this.paymentButton, this.amortizeButton}));
        return builder.getPanel();
    }

    private void amortizeAction() {
        AmortizeObject ao = (AmortizeObject)this.account.getProperty(AccountProperty.AMORTIZEOBJECT);
        AmortizeDialog d = new AmortizeDialog(ao);
        d.setVisible(true);
        if (d.getResult()) {
            this.engine.setAmortizeObject(this.account, d.getAmortizeObject());
        }
    }

    private void paymentActionDebit() {
        AmortizeObject ao = (AmortizeObject)this.account.getProperty(AccountProperty.AMORTIZEOBJECT);
        if (ao != null) {
            double interest;
            Transaction tran = null;
            DateChkNumberDialog d = new DateChkNumberDialog(ao.getBankAccount(), this.rb.getString("Title.NewTrans"));
            d.setVisible(true);
            if (!d.getResult()) {
                return;
            }
            BigDecimal balance = this.account.getBalance().abs();
            double payment = ao.getPayment();
            if (ao.getUseDailyRate()) {
                Date today = d.getDate();
                Date last = this.account.getTransactionCount() > 0 ? this.account.getTransactionAt(this.account.getTransactionCount() - 1).getDate() : today;
                interest = ao.getIPayment(balance, last, today);
            } else {
                interest = ao.getIPayment(balance);
            }
            Account bank = ao.getBankAccount();
            if (bank != null) {
                Account f;
                CurrencyNode n = bank.getCurrencyNode();
                Transaction transaction = new Transaction();
                transaction.setDate(d.getDate());
                transaction.setNumber(d.getNumber());
                transaction.setPayee(ao.getPayee());
                TransactionEntry e = new TransactionEntry();
                e.setCreditAccount(this.account);
                e.setDebitAccount(bank);
                e.setAmount(n.round(payment - interest));
                e.setMemo(ao.getMemo());
                transaction.addTransactionEntry(e);
                Account i = ao.getInterestAccount();
                if (i != null) {
                    e = new TransactionEntry();
                    e.setCreditAccount(i);
                    e.setDebitAccount(bank);
                    e.setAmount(n.round(interest));
                    e.setMemo(this.rb.getString("Word.Interest"));
                    transaction.addTransactionEntry(e);
                }
                if (ao.getFees().compareTo(BigDecimal.ZERO) != 0 && (f = ao.getFeesAccount()) != null) {
                    e = new TransactionEntry();
                    e.setCreditAccount(f);
                    e.setDebitAccount(bank);
                    e.setAmount(ao.getFees());
                    e.setMemo(this.rb.getString("Word.Fees"));
                    transaction.addTransactionEntry(e);
                }
                tran = transaction;
            }
            if (tran != null) {
                EditTransactionDialog dlg = new EditTransactionDialog(ao.getBankAccount(), PanelType.DECREASE);
                dlg.newTransaction(tran);
                dlg.setVisible(true);
            } else {
                Logger.getLogger(Engine.class.getName()).warning("Not enough information");
            }
        } else {
            Logger.getLogger(Engine.class.getName()).warning("Please configure amortization");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        super.actionPerformed(e);
        if (e.getSource() == this.amortizeButton) {
            this.amortizeAction();
        } else if (e.getSource() == this.paymentButton) {
            this.paymentActionDebit();
        }
    }
}

