/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.invest;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.math.BigDecimal;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.ReconciledState;
import jgnash.engine.SecurityNode;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.engine.TransactionType;
import jgnash.ui.register.invest.AbstractPriceQtyInvTransactionPanel;
import jgnash.ui.util.ValidationFactory;

public final class SplitMergeSharePanel
extends AbstractPriceQtyInvTransactionPanel {
    private TransactionType tranType;

    protected SplitMergeSharePanel(Account account, TransactionType tranType) {
        super(account);
        assert (tranType == TransactionType.SPLITSHARE || tranType == TransactionType.MERGESHARE);
        this.tranType = tranType;
        this.layoutMainPanel();
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                SplitMergeSharePanel.this.updateTotalField();
            }
        };
        this.quantityField.addFocusListener(focusListener);
        this.priceField.addFocusListener(focusListener);
        this.securityCombo.addKeyListener(this.keyListener);
        this.datePanel.getDateField().addKeyListener(this.keyListener);
        this.quantityField.addKeyListener(this.keyListener);
        this.memoField.addKeyListener(this.keyListener);
        this.priceField.addKeyListener(this.keyListener);
        this.clearForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:d, $lcgap, 50dlu:g, 8dlu, right:d, $lcgap, max(65dlu;min)", "f:d, $nlgap, f:d, $nlgap, f:d");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        CellConstraints cc = new CellConstraints();
        this.setLayout((LayoutManager)layout);
        JPanel subPanel = this.buildHorizontalSubPanel("max(48dlu;min):g(0.5), 8dlu, d, $lcgap, max(48dlu;min):g(0.5)", ValidationFactory.wrap(this.priceField), "Label.Quantity", ValidationFactory.wrap(this.quantityField));
        this.add("Label.Security", (Object)cc.xy(1, 1));
        this.add((Component)ValidationFactory.wrap(this.securityCombo), (Object)cc.xy(3, 1));
        this.add("Label.Date", (Object)cc.xy(5, 1));
        this.add((Component)this.datePanel, (Object)cc.xy(7, 1));
        this.add("Label.Price", (Object)cc.xy(1, 3));
        this.add((Component)subPanel, (Object)cc.xy(3, 3));
        this.add("Label.Total", (Object)cc.xy(5, 3));
        this.add((Component)this.totalField, (Object)cc.xy(7, 3));
        this.add("Label.Memo", (Object)cc.xy(1, 5));
        this.add((Component)this.memoField, (Object)cc.xy(3, 5));
        this.add((Component)this.reconciledButton, (Object)cc.xyw(5, 5, 3));
    }

    @Override
    public void clearForm() {
        super.clearForm();
        this.updateTotalField();
    }

    @Override
    public void modifyTransaction(Transaction tran) {
        assert (tran instanceof InvestmentTransaction);
        assert (tran.getTransactionType() == TransactionType.SPLITSHARE || tran.getTransactionType() == TransactionType.MERGESHARE);
        InvestmentTransaction _tran = (InvestmentTransaction)tran;
        this.clearForm();
        this.modTrans = tran;
        this.datePanel.setDate(tran.getDate());
        this.memoField.setText(tran.getMemo());
        this.priceField.setDecimal(_tran.getPrice());
        this.quantityField.setDecimal(_tran.getQuantity());
        this.securityCombo.setSelectedNode(_tran.getSecurityNode());
        this.reconciledButton.setSelected(tran.getReconciled(this.getAccount()) == ReconciledState.RECONCILED);
        this.updateTotalField();
    }

    @Override
    public Transaction buildTransaction() {
        if (this.tranType == TransactionType.SPLITSHARE) {
            return TransactionFactory.generateSplitXTransaction(this.account, (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected());
        }
        return TransactionFactory.generateMergeXTransaction(this.account, (SecurityNode)this.securityCombo.getSelectedNode(), this.priceField.getDecimal(), this.quantityField.getDecimal(), this.datePanel.getDate(), this.memoField.getText(), this.reconciledButton.isSelected());
    }

    void updateTotalField() {
        BigDecimal quantity = this.quantityField.getDecimal();
        BigDecimal price = this.priceField.getDecimal();
        this.totalField.setDecimal(quantity.multiply(price));
    }
}

