/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.ToolTipManager;
import javax.swing.table.TableCellRenderer;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.Transaction;
import jgnash.text.CommodityFormat;
import jgnash.ui.components.FormattedJTable;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.AccountTableModel;
import jgnash.ui.register.table.FullCommodityStyle;
import jgnash.ui.register.table.QuantityStyle;
import jgnash.ui.register.table.ShortCommodityStyle;
import jgnash.ui.register.table.SortedTableModel;

public class RegisterTable
extends FormattedJTable {
    private NumberFormat fullFormat;
    private NumberFormat shortFormat;

    public RegisterTable(AccountTableModel dm) {
        super(dm);
        this.init();
    }

    private void init() {
        this.setAutoResizeMode(1);
        this.setCellSelectionEnabled(true);
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.getSelectionModel().setSelectionMode(2);
        this.setShowGrid(false);
        this.setFillsViewportHeight(true);
        AccountTableModel model = (AccountTableModel)this.getModel();
        CurrencyNode node = model.getAccount().getCurrencyNode();
        this.fullFormat = CommodityFormat.getFullNumberFormat(node);
        this.shortFormat = CommodityFormat.getShortNumberFormat(node);
        ToolTipManager.sharedInstance().unregisterComponent(this.getTableHeader());
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Object value;
        Component c = super.prepareRenderer(renderer, row, column);
        if (this.getModel() instanceof AbstractRegisterTableModel) {
            Transaction t = ((AbstractRegisterTableModel)this.getModel()).getTransactionAt(row);
            if (t.getDate().after(new Date())) {
                c.setFont(c.getFont().deriveFont(2));
            }
            if (QuantityStyle.class.isAssignableFrom(this.getColumnClass(column)) && t instanceof InvestmentTransaction && c instanceof JLabel) {
                ((JLabel)c).setHorizontalAlignment(4);
                NumberFormat numberFormat = CommodityFormat.getShortNumberFormat(((InvestmentTransaction)t).getSecurityNode());
                Object value2 = this.getModel().getValueAt(row, column);
                if (value2 != null && value2 instanceof Number) {
                    ((JLabel)c).setText(numberFormat.format(value2));
                } else {
                    ((JLabel)c).setText("");
                }
            }
        }
        if (FullCommodityStyle.class.isAssignableFrom(this.getColumnClass(column)) && c instanceof JLabel) {
            ((JLabel)c).setHorizontalAlignment(4);
            value = this.getModel().getValueAt(row, column);
            if (value != null && value instanceof Number) {
                if (!this.isRowSelected(row) && ((BigDecimal)value).signum() < 0) {
                    c.setForeground(Color.RED);
                }
                ((JLabel)c).setText(this.fullFormat.format(value));
            } else {
                ((JLabel)c).setText("");
            }
        } else if (ShortCommodityStyle.class.isAssignableFrom(this.getColumnClass(column)) && c instanceof JLabel) {
            ((JLabel)c).setHorizontalAlignment(4);
            value = this.getModel().getValueAt(row, column);
            if (value != null && value instanceof Number) {
                ((JLabel)c).setText(this.shortFormat.format(value));
            } else {
                ((JLabel)c).setText("");
            }
        }
        return c;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int[] rows = this.getSelectedRows();
        if (rows.length > 1) {
            AccountTableModel model = (AccountTableModel)this.getModel();
            Account account = model.getAccount();
            CurrencyNode node = account.getCurrencyNode();
            BigDecimal amount = BigDecimal.ZERO;
            if (model instanceof SortedTableModel) {
                for (int i = 0; i < rows.length; ++i) {
                    rows[i] = ((SortedTableModel)model).convertRowIndexToAccount(rows[i]);
                }
            }
            for (int row : rows) {
                amount = amount.add(AccountBalanceDisplayManager.convertToSelectedBalanceMode(account.getAccountType(), account.getTransactionAt(row).getAmount(account)));
            }
            return CommodityFormat.getFullNumberFormat(node).format(amount);
        }
        return null;
    }
}

