/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report;

import com.lowagie.text.DocumentException;
import com.lowagie.text.pdf.BaseFont;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import jgnash.util.OS;

public class FontRegistry {
    private final Map<String, String> registeredFontMap = new HashMap<String, String>();
    private static FontRegistry registry;
    private static final AtomicBoolean registrationComplete;
    private static final AtomicBoolean registrationStarted;

    private FontRegistry() {
    }

    static String getRegisteredFontPath(String name) {
        if (!registrationStarted.get()) {
            FontRegistry.registerFonts();
        }
        if (!registrationComplete.get()) {
            while (!registrationComplete.get()) {
                try {
                    Thread.sleep(500L);
                    System.out.println("Waiting for font registration to complete");
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        return FontRegistry.registry.registeredFontMap.get(name.toLowerCase());
    }

    public static void registerFonts() {
        if (!registrationStarted.get()) {
            registrationStarted.set(true);
            Thread thread = new Thread(){

                @Override
                public void run() {
                    registry = new FontRegistry();
                    registry.registerFontDirectories();
                    registrationComplete.set(true);
                    System.out.println("Font registration is complete");
                }
            };
            thread.setPriority(1);
            thread.start();
        }
    }

    private void registerFont(String path) {
        try {
            if (path.toLowerCase().endsWith(".ttf") || path.toLowerCase().endsWith(".otf") || path.toLowerCase().indexOf(".ttc,") > 0) {
                String[][] names;
                Object[] allNames = BaseFont.getAllFontNames((String)path, (String)"Cp1252", null);
                for (String[] name : names = (String[][])allNames[2]) {
                    this.registeredFontMap.put(name[3].toLowerCase(), path);
                }
            } else if (path.toLowerCase().endsWith(".ttc")) {
                String[] names = BaseFont.enumerateTTCNames((String)path);
                for (int i = 0; i < names.length; ++i) {
                    this.registerFont(path + "," + i);
                }
            } else if (path.toLowerCase().endsWith(".afm") || path.toLowerCase().endsWith(".pfm")) {
                BaseFont bf = BaseFont.createFont((String)path, (String)"Cp1252", (boolean)false);
                String fullName = bf.getFullFontName()[0][3].toLowerCase();
                this.registeredFontMap.put(fullName, path);
            }
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void registerFontDirectory(String dir) {
        String[] files;
        File directory = new File(dir);
        if (directory.isDirectory() && (files = directory.list()) != null) {
            for (String path : files) {
                try {
                    String suffix;
                    File file = new File(dir, path);
                    if (file.isDirectory()) {
                        this.registerFontDirectory(file.getAbsolutePath());
                        continue;
                    }
                    String name = file.getPath();
                    String string = suffix = name.length() < 4 ? null : name.substring(name.length() - 3).toLowerCase();
                    if (suffix == null) continue;
                    switch (suffix) {
                        case "afm": 
                        case "pfm": {
                            File pfb = new File(name.substring(0, name.length() - 3) + "pfb");
                            if (!pfb.exists()) break;
                            this.registerFont(name);
                            break;
                        }
                        case "ttf": 
                        case "otf": 
                        case "ttc": {
                            this.registerFont(name);
                        }
                    }
                }
                catch (Exception ignored) {
                    Logger.getLogger(FontRegistry.class.getName()).finest(MessageFormat.format("Could not find path for {0}", path));
                }
            }
        }
    }

    void registerFontDirectories() {
        if (OS.isSystemWindows()) {
            this.registerFontDirectory("c:/windows/fonts");
            this.registerFontDirectory("c:/winnt/fonts");
            this.registerFontDirectory("d:/windows/fonts");
            this.registerFontDirectory("d:/winnt/fonts");
        } else if (OS.isSystemOSX()) {
            String userhome = System.getProperty("user.home");
            this.registerFontDirectory(userhome + "/Library/Fonts");
            this.registerFontDirectory("/Library/Fonts");
            this.registerFontDirectory("/Network/Library/Fonts");
            this.registerFontDirectory("/System/Library/Fonts");
        } else {
            this.registerFontDirectory("/usr/share/X11/fonts");
            this.registerFontDirectory("/usr/X/lib/X11/fonts");
            this.registerFontDirectory("/usr/openwin/lib/X11/fonts");
            this.registerFontDirectory("/usr/share/fonts");
            this.registerFontDirectory("/usr/X11R6/lib/X11/fonts");
        }
    }

    static {
        registrationComplete = new AtomicBoolean(false);
        registrationStarted = new AtomicBoolean(false);
    }
}

