/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.ui.components.DatePanel;
import jgnash.ui.report.AbstractReportTableModel;
import jgnash.ui.report.ColumnHeaderStyle;
import jgnash.ui.report.ColumnStyle;
import jgnash.ui.report.jasper.DynamicJasperReport;
import jgnash.util.DateUtils;
import jgnash.util.Resource;
import net.sf.jasperreports.engine.JasperPrint;

abstract class AbstractSumByTypeReport
extends DynamicJasperReport {
    private DatePanel startDateField;
    private DatePanel endDateField;
    private JButton refreshButton;
    private JCheckBox hideZeroBalanceAccounts;
    private static final String HIDE_ZERO_BALANCE = "hideZeroBalance";
    private static final String MONTHS = "months";

    public AbstractSumByTypeReport() {
        Preferences p = this.getPreferences();
        int months = p.getInt(MONTHS, 5);
        Date startDate = new Date();
        for (int i = 0; i < months - 1; ++i) {
            startDate = DateUtils.subtractMonth(startDate);
        }
        this.startDateField = new DatePanel();
        this.endDateField = new DatePanel();
        this.hideZeroBalanceAccounts = new JCheckBox(Resource.get().getString("Button.HideZeroBalance"));
        this.hideZeroBalanceAccounts.setSelected(p.getBoolean(HIDE_ZERO_BALANCE, true));
        this.startDateField.setDate(startDate);
        this.refreshButton = new JButton(this.rb.getString("Button.Refresh"), Resource.getIcon("/jgnash/resource/view-refresh.png"));
        this.refreshButton.addActionListener(new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ae) {
                AbstractSumByTypeReport.this.refreshReport();
            }
        });
    }

    @Override
    protected void refreshReport() {
        Preferences p = this.getPreferences();
        p.putBoolean(HIDE_ZERO_BALANCE, this.hideZeroBalanceAccounts.isSelected());
        p.putInt(MONTHS, DateUtils.getLastDayOfTheMonths(this.startDateField.getDate(), this.endDateField.getDate()).size());
        super.refreshReport();
    }

    protected abstract List<AccountGroup> getAccountGroups();

    private ReportModel createTableModel(Date startDate, Date endDate) {
        logger.info(this.rb.getString("Message.CollectingReportData"));
        CurrencyNode baseCurrency = EngineFactory.getEngine("default").getDefaultCurrency();
        ArrayList<Account> accounts = new ArrayList<Account>();
        for (AccountGroup group : this.getAccountGroups()) {
            accounts.addAll(AbstractSumByTypeReport.getAccountList(AccountType.getAccountTypes(group)));
        }
        if (this.hideZeroBalanceAccounts.isSelected()) {
            List<Date> dates = DateUtils.getLastDayOfTheMonths(startDate, endDate);
            Iterator i = accounts.iterator();
            while (i.hasNext()) {
                Account account = (Account)i.next();
                boolean remove = true;
                for (Date date : dates) {
                    if (account.getBalance(date).compareTo(BigDecimal.ZERO) == 0) continue;
                    remove = false;
                    break;
                }
                if (!remove) continue;
                i.remove();
            }
        }
        return new ReportModel(accounts, startDate, endDate, baseCurrency);
    }

    private static List<Account> getAccountList(Set<AccountType> types) {
        Engine engine = EngineFactory.getEngine("default");
        TreeSet<Account> accountSet = new TreeSet<Account>();
        for (Account a : engine.getAccountList()) {
            if (!types.contains((Object)a.getAccountType())) continue;
            accountSet.add(a);
        }
        return new ArrayList<Account>(accountSet);
    }

    @Override
    public JasperPrint createJasperPrint(boolean formatForCSV) {
        Date endDate = this.endDateField.getDate();
        Date startDate = this.startDateField.getDate();
        ReportModel model = this.createTableModel(startDate, endDate);
        return this.createJasperPrint(model, formatForCSV);
    }

    @Override
    public JPanel getReportController() {
        FormLayout layout = new FormLayout("p, $lcgap, max(p;55dlu), 8dlu, p, $lcgap, max(p;55dlu), 8dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append(this.rb.getString("Label.StartDate"), (Component)this.startDateField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)this.endDateField);
        builder.append((Component)this.refreshButton);
        builder.nextLine();
        builder.append((Component)this.hideZeroBalanceAccounts, 9);
        return builder.getPanel();
    }

    private static class ReportModel
    extends AbstractReportTableModel {
        private CurrencyNode baseCurrency;
        private List<Account> accountList = Collections.emptyList();
        private List<Date> dates = Collections.emptyList();
        private DateFormat dateFormat = DateFormat.getDateInstance(3);
        private Resource rb = Resource.get();
        private static final long serialVersionUID = -2526030825754030630L;

        protected ReportModel(List<Account> accountList, Date startDate, Date endDate, CurrencyNode currency) {
            this.accountList = accountList;
            this.baseCurrency = currency;
            this.dates = DateUtils.getLastDayOfTheMonths(startDate, endDate);
        }

        @Override
        public CurrencyNode getCurrency() {
            return this.baseCurrency;
        }

        @Override
        public int getRowCount() {
            return this.accountList.size();
        }

        @Override
        public int getColumnCount() {
            return this.dates.size() + 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return this.rb.getString("Column.Account");
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return "Type";
            }
            return this.dateFormat.format(this.dates.get(columnIndex - 1));
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return String.class;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return String.class;
            }
            return BigDecimal.class;
        }

        @Override
        public ColumnStyle getColumnStyle(int columnIndex) {
            if (columnIndex == 0) {
                return ColumnStyle.STRING;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return ColumnStyle.GROUP;
            }
            return ColumnStyle.BALANCE_WITH_SUM_AND_GLOBAL;
        }

        @Override
        public ColumnHeaderStyle getColumnHeaderStyle(int columnIndex) {
            if (columnIndex == 0) {
                return ColumnHeaderStyle.LEFT;
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return ColumnHeaderStyle.CENTER;
            }
            return ColumnHeaderStyle.RIGHT;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Account a = this.accountList.get(rowIndex);
            if (columnIndex == 0) {
                return a.getName();
            }
            if (columnIndex == this.getColumnCount() - 1) {
                return a.getAccountType().getAccountGroup().toString();
            }
            if (columnIndex > 0 && columnIndex <= this.dates.size()) {
                return a.getBalance(this.dates.get(columnIndex - 1), this.getCurrency());
            }
            return null;
        }
    }
}

