/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JPanel;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.ui.components.GenericCloseDialog;
import jgnash.ui.components.SecurityComboBox;
import jgnash.util.Resource;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.HighLowItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.HighLowRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.AbstractXYDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYDataset;

public class SecurityHighLowChart {
    private SecurityComboBox combo;
    private Resource rb = Resource.get();
    private ChartPanel chartPanel;

    public static void show() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Resource rb = Resource.get();
                SecurityHighLowChart chart = new SecurityHighLowChart();
                JPanel p = chart.createPanel();
                GenericCloseDialog d = new GenericCloseDialog(p, rb.getString("Title.AccountBalance"));
                d.pack();
                d.setModal(false);
                d.setVisible(true);
            }
        });
    }

    private static JFreeChart createHighLowChart(String title, String timeAxisLabel, String valueAxisLabel, AbstractXYDataset data, boolean legend) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        HighLowRenderer renderer = new HighLowRenderer();
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)new HighLowItemLabelGenerator());
        XYPlot plot = new XYPlot((XYDataset)data, (ValueAxis)timeAxis, (ValueAxis)valueAxis, (XYItemRenderer)renderer);
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, legend);
    }

    private static AbstractXYDataset createHighLowDataset(SecurityNode node) {
        assert (node != null);
        List<SecurityHistoryNode> hNodes = node.getHistoryNodes();
        int count = hNodes.size();
        Date[] date = new Date[count];
        double[] high = new double[count];
        double[] low = new double[count];
        double[] open = new double[count];
        double[] close = new double[count];
        double[] volume = new double[count];
        for (int i = 0; i < count; ++i) {
            SecurityHistoryNode hNode = hNodes.get(i);
            date[i] = hNode.getDate();
            high[i] = hNode.getHigh().doubleValue();
            low[i] = hNode.getLow().doubleValue();
            open[i] = hNode.getPrice().doubleValue();
            close[i] = hNode.getPrice().doubleValue();
            volume[i] = hNode.getVolume();
        }
        return new DefaultHighLowDataset((Comparable)((Object)node.getDescription()), date, high, low, open, close, volume);
    }

    private void updateChart() {
        try {
            SecurityNode sNode = this.combo.getSelectedSecurityNode();
            if (sNode != null) {
                AbstractXYDataset dataset = SecurityHighLowChart.createHighLowDataset(sNode);
                JFreeChart chart = SecurityHighLowChart.createHighLowChart(sNode.getDescription(), this.rb.getString("Column.Date"), this.rb.getString("Column.Price"), dataset, false);
                chart.setBackgroundPaint(null);
                this.chartPanel.setChart(chart);
                this.chartPanel.validate();
            }
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().severe(ex.toString());
        }
    }

    JPanel createPanel() {
        this.combo = new SecurityComboBox();
        this.chartPanel = new ChartPanel(new JFreeChart((Plot)new XYPlot()));
        FormLayout layout = new FormLayout("p, 4dlu:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.combo);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"fill:p:g"));
        builder.append((Component)this.chartPanel, 2);
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SecurityHighLowChart.this.updateChart();
            }
        });
        return builder.getPanel();
    }
}

