/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.file;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.StyledEditorKit;
import jgnash.engine.DataStoreType;
import jgnash.engine.EngineFactory;
import jgnash.ui.actions.DatabasePathAction;
import jgnash.ui.components.DataStoreTypeCombo;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.TextResource;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.util.FileUtils;
import jgnash.util.Resource;

public class NewFileOne
extends JPanel
implements WizardPage,
ActionListener {
    protected final Resource rb = Resource.get();
    private JTextField dbNameField = new JTextField();
    private JButton dbNameButton;
    private JLabel overwriteLabel;
    private JEditorPane helpPane;
    private DataStoreTypeCombo typeCombo;

    public NewFileOne() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("NewFileOne.txt"));
        this.dbNameButton = new JButton("...");
        this.dbNameButton.addActionListener(this);
        this.overwriteLabel = new JLabel(this.rb.getString("Message.Overwritedb"));
        this.overwriteLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        this.overwriteLabel.setFont(this.overwriteLabel.getFont().deriveFont(2));
        this.typeCombo = new DataStoreTypeCombo();
        this.typeCombo.addActionListener(this);
        this.dbNameField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                NewFileOne.this.checkForOverwrite();
            }
        });
        this.typeCombo.setSelectedItem((Object)DataStoreType.BINARY_XSTREAM);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 8dlu, f:d:g, 4dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.DatabaseCfg"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.StorageType"), (Component)this.typeCombo);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.DatabaseName"), (Component)this.dbNameField, (Component)this.dbNameButton);
        builder.nextLine();
        builder.append((Component)this.overwriteLabel, 5);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
    }

    @Override
    public boolean isPageValid() {
        return this.dbNameField.getText().length() > 0;
    }

    @Override
    public String toString() {
        return "1. " + this.rb.getString("Title.DatabaseCfg");
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
        String fileName;
        DataStoreType type = (DataStoreType)((Object)map.get((Object)NewFileDialog.Settings.TYPE));
        if (type != null) {
            this.typeCombo.setSelectedItem((Object)type);
        }
        if (FileUtils.fileHasExtension(fileName = (String)map.get((Object)NewFileDialog.Settings.DATABASE_NAME))) {
            this.dbNameField.setText(fileName);
        } else {
            this.dbNameField.setText(fileName + "." + this.typeCombo.getSelectedDataStoreType().getDataStore().getFileExt());
        }
        this.checkForOverwrite();
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
        map.put(NewFileDialog.Settings.DATABASE_NAME, this.dbNameField.getText());
        map.put(NewFileDialog.Settings.TYPE, (Object)this.typeCombo.getSelectedDataStoreType());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.dbNameButton) {
            this.databaseNameAction();
        } else if (event.getSource() == this.typeCombo) {
            this.updateFileExtensionAction();
        }
    }

    private void updateFileExtensionAction() {
        if (this.dbNameField.getText().length() > 0) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    String fileName = FileUtils.stripFileExtension(NewFileOne.this.dbNameField.getText());
                    NewFileOne.this.dbNameField.setText(fileName + "." + NewFileOne.this.typeCombo.getSelectedDataStoreType().getDataStore().getFileExt());
                }
            });
        }
    }

    private void databaseNameAction() {
        String result = DatabasePathAction.databaseNameAction(this, DatabasePathAction.Type.NEW, this.typeCombo.getSelectedDataStoreType());
        if (result.length() > 0) {
            this.dbNameField.setText(result);
            this.checkForOverwrite();
        }
    }

    private void checkForOverwrite() {
        String database = this.dbNameField.getText();
        this.overwriteLabel.setVisible(EngineFactory.doesDatabaseExist(database, this.typeCombo.getSelectedDataStoreType()));
    }
}

