/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.RowSorter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jgnash.engine.Account;
import jgnash.imports.ImportTransaction;
import jgnash.ui.components.AccountListComboBox;
import jgnash.ui.components.FormattedJTable;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

class ImportTable
extends FormattedJTable {
    private Resource rb = Resource.get();
    private Model model;
    private TableCellEditor accEditor = new DefaultCellEditor(new AccountListComboBox());
    private List<? extends ImportTransaction> transactions = Collections.emptyList();

    public ImportTable() {
        this.model = new Model();
        this.setAutoCreateRowSorter(true);
        this.setModel(this.model);
        RowSorter<? extends TableModel> rowSorter = this.getRowSorter();
        if (rowSorter instanceof DefaultRowSorter) {
            ((DefaultRowSorter)rowSorter).setSortable(0, false);
        }
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(final MouseEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int row = ImportTable.this.rowAtPoint(e.getPoint());
                        int col = ImportTable.this.columnAtPoint(e.getPoint());
                        if (col == 0 && row >= 0) {
                            row = ImportTable.this.convertRowIndexToModel(row);
                            if ((col = ImportTable.this.convertColumnIndexToModel(col)) == 0) {
                                ImportTransaction t = (ImportTransaction)ImportTable.this.transactions.get(row);
                                if (t.getState() == ImportTransaction.ImportState.EQUAL) {
                                    t.setState(ImportTransaction.ImportState.NOT_EQUAL);
                                    ImportTable.this.model.fireTableCellUpdated(row, col);
                                } else if (t.getState() == ImportTransaction.ImportState.NOT_EQUAL) {
                                    t.setState(ImportTransaction.ImportState.EQUAL);
                                    ImportTable.this.model.fireTableCellUpdated(row, col);
                                } else if (t.getState() == ImportTransaction.ImportState.NEW) {
                                    t.setState(ImportTransaction.ImportState.IGNORE);
                                    ImportTable.this.model.fireTableCellUpdated(row, col);
                                } else if (t.getState() == ImportTransaction.ImportState.IGNORE) {
                                    t.setState(ImportTransaction.ImportState.NEW);
                                    ImportTable.this.model.fireTableCellUpdated(row, col);
                                }
                            }
                        }
                    }
                });
            }
        });
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        Component c = super.prepareRenderer(renderer, row, column);
        if (column == 0) {
            Icon icon = (Icon)this.model.getValueAt(row, column);
            ((JLabel)c).setHorizontalAlignment(0);
            ((JLabel)c).setIcon(icon);
            ((JLabel)c).setText(null);
        }
        return c;
    }

    public List<? extends ImportTransaction> getTransactions() {
        return this.transactions;
    }

    public void setTransactions(List<? extends ImportTransaction> transactions) {
        this.transactions = transactions;
    }

    public void deleteSelected() {
        int row = this.getSelectedRow();
        this.transactions.remove(row);
        this.model.fireTableRowsDeleted(row, row);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        if (column == 5) {
            return this.accEditor;
        }
        return super.getCellEditor(row, column);
    }

    public void fireTableDataChanged() {
        this.model.fireTableDataChanged();
    }

    static /* synthetic */ Resource access$200(ImportTable x0) {
        return x0.rb;
    }

    class Model
    extends AbstractTableModel {
        private static final long serialVersionUID = -6597047721167146695L;
        private ImageIcon equalIcon = null;
        private ImageIcon addIcon = null;
        private ImageIcon notEqualIcon = null;
        private ImageIcon removeIcon = null;
        private String[] cNames = new String[]{" ", ImportTable.access$200(ImportTable.this).getString("Column.Date"), ImportTable.access$200(ImportTable.this).getString("Column.Num"), ImportTable.access$200(ImportTable.this).getString("Column.Payee"), ImportTable.access$200(ImportTable.this).getString("Column.Memo"), ImportTable.access$200(ImportTable.this).getString("Column.Account"), ImportTable.access$200(ImportTable.this).getString("Column.Amount")};
        private Class<?>[] cClass = new Class[]{String.class, String.class, String.class, String.class, String.class, String.class, BigDecimal.class};
        private DateFormat dateFormatter = DateUtils.getShortDateFormat();

        public Model() {
            this.notEqualIcon = Resource.getIcon("/jgnash/resource/not-equal.png");
            this.notEqualIcon.setDescription("not");
            this.equalIcon = Resource.getIcon("/jgnash/resource/equal.png");
            this.equalIcon.setDescription("equals");
            this.addIcon = Resource.getIcon("/jgnash/resource/add.png");
            this.addIcon.setDescription("add");
            this.removeIcon = Resource.getIcon("/jgnash/resource/remove.png");
            this.removeIcon.setDescription("remove");
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.cClass[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 5;
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            return ImportTable.this.transactions.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            ImportTransaction transaction = (ImportTransaction)ImportTable.this.transactions.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    if (transaction.getState() == ImportTransaction.ImportState.EQUAL) {
                        return this.equalIcon;
                    }
                    if (transaction.getState() == ImportTransaction.ImportState.NOT_EQUAL) {
                        return this.notEqualIcon;
                    }
                    if (transaction.getState() == ImportTransaction.ImportState.IGNORE) {
                        return this.removeIcon;
                    }
                    return this.addIcon;
                }
                case 1: {
                    return this.dateFormatter.format(transaction.datePosted);
                }
                case 2: {
                    return transaction.checkNumber;
                }
                case 3: {
                    return transaction.payee;
                }
                case 4: {
                    return transaction.memo;
                }
                case 5: {
                    if (transaction.account != null) {
                        return transaction.account.toString();
                    }
                    return null;
                }
                case 6: {
                    return transaction.amount;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            if (columnIndex == 5 && value != null) {
                ImportTransaction transaction = (ImportTransaction)ImportTable.this.transactions.get(rowIndex);
                transaction.account = (Account)value;
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }
}

