/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.imports.jgnash;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.StyledEditorKit;
import jgnash.ui.actions.ImportPathAction;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.TextResource;
import jgnash.ui.wizards.imports.jgnash.ImportDialog;
import jgnash.util.FileMagic;
import jgnash.util.Resource;

public class ImportZero
extends JPanel
implements WizardPage,
ActionListener {
    private final Resource rb = Resource.get();
    private JTextField fileImportField = new JTextField();
    private JButton fileImportButton;
    private JLabel validFileLabel;
    private JEditorPane helpPane;
    private boolean valid = false;

    public ImportZero() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("ImportFileZero.txt"));
        this.fileImportButton = new JButton("...");
        this.fileImportButton.addActionListener(this);
        this.validFileLabel = new JLabel(this.rb.getString("Message.FileNotValid"));
        this.validFileLabel.setIcon(UIManager.getIcon("OptionPane.warningIcon"));
        this.validFileLabel.setFont(this.validFileLabel.getFont().deriveFont(2));
        this.fileImportField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                ImportZero.this.validateFile();
            }
        });
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, 8dlu, f:d:g, 4dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.FileImport"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.helpPane, 3);
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.FileName"), (Component)this.fileImportField, (Component)this.fileImportButton);
        builder.nextLine();
        builder.append((Component)this.validFileLabel, 5);
    }

    @Override
    public boolean isPageValid() {
        return this.valid;
    }

    @Override
    public String toString() {
        return "1. " + this.rb.getString("Title.FileImport");
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
        this.fileImportField.setText((String)map.get((Object)ImportDialog.Settings.IMPORTFILE));
        this.validateFile();
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
        map.put(ImportDialog.Settings.IMPORTFILE, this.fileImportField.getText());
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.fileImportButton) {
            this.databaseNameAction();
        }
    }

    private void databaseNameAction() {
        String result = ImportPathAction.databaseNameAction(this);
        if (result.length() > 0) {
            this.fileImportField.setText(result);
            this.validateFile();
        }
    }

    private void validateFile() {
        File file = new File(this.fileImportField.getText());
        if (file.exists()) {
            this.valid = FileMagic.isValidjGnash1File(file);
            this.validFileLabel.setVisible(!this.valid);
        } else {
            this.validFileLabel.setVisible(true);
            this.valid = false;
        }
    }
}

