/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jxlayer.plaf.effect;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.ref.SoftReference;
import org.jdesktop.jxlayer.plaf.effect.AbstractLayerEffect;

public class AbstractBufferedImageOpEffect
extends AbstractLayerEffect {
    private transient SoftReference<BufferedImage> cachedSubImage;
    private static final BufferedImageOp[] emptyOpsArray = new BufferedImageOp[0];

    @Override
    public void apply(BufferedImage buffer, Shape clip) {
        BufferedImage subImage;
        Rectangle clipBounds;
        if (buffer == null) {
            throw new IllegalArgumentException("BufferedImage is null");
        }
        Rectangle bufferSize = new Rectangle(buffer.getWidth(), buffer.getHeight());
        if (clip == null) {
            clip = bufferSize;
        }
        if ((clipBounds = clip.getBounds().intersection(bufferSize)).isEmpty() || buffer.getWidth() <= clipBounds.x || buffer.getHeight() <= clipBounds.y) {
            return;
        }
        int x = clipBounds.x;
        int y = clipBounds.y;
        int width = clipBounds.width;
        int height = clipBounds.height;
        if (buffer.getWidth() < x + width) {
            width = buffer.getWidth() - x;
        }
        if (buffer.getHeight() < y + height) {
            height = buffer.getHeight() - y;
        }
        BufferedImage bufferedImage = subImage = this.cachedSubImage == null ? null : this.cachedSubImage.get();
        if (subImage == null || subImage.getWidth() != width || subImage.getHeight() != height) {
            subImage = new BufferedImage(width, height, buffer.getType());
            this.cachedSubImage = new SoftReference<BufferedImage>(subImage);
        }
        Graphics2D bufg = buffer.createGraphics();
        bufg.setClip(clip);
        Graphics2D subg = subImage.createGraphics();
        for (BufferedImageOp op : this.getBufferedImageOps()) {
            subg.drawImage(buffer, 0, 0, width, height, x, y, x + width, y + height, null);
            bufg.drawImage(subImage, op, x, y);
        }
        subg.dispose();
        bufg.dispose();
    }

    protected BufferedImageOp[] getBufferedImageOps() {
        return emptyOpsArray;
    }
}

