/*
 * Decompiled with CFR 0.152.
 */
package jgnash.imports.ofx;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import jgnash.engine.Account;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionFactory;
import jgnash.imports.ImportTransaction;
import jgnash.imports.ofx.OfxBank;
import jgnash.imports.ofx.OfxTransaction;

public class OfxImport {
    public static void importTransactions(List<OfxTransaction> transactions, Account baseAccount) {
        assert (transactions != null && baseAccount != null);
        Engine engine = EngineFactory.getEngine((String)"default");
        for (OfxTransaction tran : transactions) {
            Transaction t;
            assert (tran.account != null);
            if (tran.getState() != ImportTransaction.ImportState.NEW && tran.getState() != ImportTransaction.ImportState.NOTEQUAL || (t = baseAccount.equals((Object)tran.account) ? TransactionFactory.generateSingleEntryTransaction((Account)baseAccount, (BigDecimal)tran.amount, (Date)tran.datePosted, (boolean)false, (String)tran.memo, (String)tran.getName(), (String)tran.checkNumber) : (tran.amount.signum() >= 0 ? TransactionFactory.generateDoubleEntryTransaction((Account)baseAccount, (Account)tran.account, (BigDecimal)tran.amount.abs(), (Date)tran.datePosted, (String)tran.memo, (String)tran.getName(), (String)tran.checkNumber) : TransactionFactory.generateDoubleEntryTransaction((Account)tran.account, (Account)baseAccount, (BigDecimal)tran.amount.abs(), (Date)tran.datePosted, (String)tran.memo, (String)tran.getName(), (String)tran.checkNumber))) == null) continue;
            t.setFitid(tran.transactionID);
            engine.addTransaction(t);
        }
    }

    public static Account matchAccount(OfxBank bank) {
        Account account;
        block2: {
            String number;
            Engine engine;
            block3: {
                engine = EngineFactory.getEngine((String)"default");
                account = null;
                number = bank.accountId;
                String symbol = bank.currency;
                CurrencyNode node = engine.getCurrency(symbol);
                if (node == null) break block3;
                for (Account a : engine.getAccountList()) {
                    if (a.getAccountNumber() == null || !a.getAccountNumber().equals(number) || !a.getCurrencyNode().equals((Object)node)) continue;
                    account = a;
                    break block2;
                }
                break block2;
            }
            if (number == null) break block2;
            for (Account a : engine.getAccountList()) {
                if (!a.getAccountNumber().equals(number)) continue;
                account = a;
                break;
            }
        }
        return account;
    }

    private OfxImport() {
    }
}

