/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.nativequery.optimization;

import EDU.purdue.cs.bloat.context.CachingBloatContext;
import EDU.purdue.cs.bloat.editor.ClassEditor;
import EDU.purdue.cs.bloat.editor.EditorContext;
import EDU.purdue.cs.bloat.file.ClassFileLoader;
import EDU.purdue.cs.bloat.file.ClassSource;
import EDU.purdue.cs.bloat.reflect.ClassInfoLoader;
import com.db4o.instrumentation.core.BloatLoaderContext;
import com.db4o.instrumentation.core.Db4oClassSource;
import com.db4o.instrumentation.core.NativeClassFactory;
import com.db4o.internal.query.Db4oNQOptimizer;
import com.db4o.nativequery.expr.Expression;
import com.db4o.nativequery.optimization.JdkReverseLookupClassFactory;
import com.db4o.nativequery.optimization.NativeQueryEnhancer;
import com.db4o.nativequery.optimization.SODAQueryBuilder;
import com.db4o.query.Predicate;
import com.db4o.query.Query;
import com.db4o.reflect.Reflector;
import java.util.ArrayList;

public class Db4oOnTheFlyEnhancer
implements Db4oNQOptimizer {
    private transient ClassFileLoader loader;
    private transient BloatLoaderContext bloatUtil;
    private transient EditorContext context;
    private Reflector reflector;

    public Db4oOnTheFlyEnhancer() {
        this(new ClassFileLoader());
    }

    public Db4oOnTheFlyEnhancer(Reflector reflector) {
        this(new ClassFileLoader((ClassSource)new Db4oClassSource((NativeClassFactory)new JdkReverseLookupClassFactory(reflector))));
        this.reflector = reflector;
    }

    private Db4oOnTheFlyEnhancer(ClassFileLoader classFileLoader) {
        this.loader = classFileLoader;
        this.bloatUtil = new BloatLoaderContext((ClassInfoLoader)classFileLoader);
        this.context = new CachingBloatContext(classFileLoader, new ArrayList(), false);
    }

    public Object optimize(Query query, Predicate predicate) {
        try {
            Expression expression = this.analyzeInternal(predicate);
            if (expression == null) {
                throw new RuntimeException("Could not analyze " + predicate);
            }
            new SODAQueryBuilder().optimizeQuery(expression, query, predicate, new JdkReverseLookupClassFactory(this.reflector));
            return expression;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new RuntimeException(classNotFoundException.getMessage());
        }
    }

    private Expression analyzeInternal(Predicate predicate) throws ClassNotFoundException {
        ClassEditor classEditor = new ClassEditor(this.context, this.loader.loadClass(predicate.getClass().getName()));
        Expression expression = new NativeQueryEnhancer().analyze(this.bloatUtil, classEditor, "match", null);
        return expression;
    }

    public static Expression analyze(Predicate predicate) throws ClassNotFoundException {
        return new Db4oOnTheFlyEnhancer().analyzeInternal(predicate);
    }
}

