/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.ObjectContainer;
import com.db4o.TransactionListener;
import com.db4o.foundation.Iterator4Impl;
import com.db4o.foundation.List4;
import com.db4o.foundation.Tree;
import com.db4o.internal.ClassMetadata;
import com.db4o.internal.DeleteInfo;
import com.db4o.internal.HardObjectReference;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.ReferenceSystem;
import com.db4o.internal.TransactionalReferenceSystem;
import com.db4o.internal.TreeInt;
import com.db4o.internal.ix.IndexTransaction;
import com.db4o.internal.slots.Pointer4;
import com.db4o.internal.slots.Slot;
import com.db4o.marshall.Context;
import com.db4o.reflect.Reflector;

public abstract class Transaction {
    protected Tree _delete;
    private List4 _dirtyFieldIndexes;
    protected final Transaction _systemTransaction;
    private final ObjectContainerBase _container;
    private ObjectContainer _objectContainer;
    private List4 _transactionListeners;
    private final TransactionalReferenceSystem _referenceSystem;

    public Transaction(ObjectContainerBase objectContainerBase, Transaction transaction, TransactionalReferenceSystem transactionalReferenceSystem) {
        this._container = objectContainerBase;
        this._systemTransaction = transaction;
        this._referenceSystem = transactionalReferenceSystem;
    }

    public void addDirtyFieldIndex(IndexTransaction indexTransaction) {
        this._dirtyFieldIndexes = new List4(this._dirtyFieldIndexes, indexTransaction);
    }

    public final void checkSynchronization() {
    }

    public void addTransactionListener(TransactionListener transactionListener) {
        this._transactionListeners = new List4(this._transactionListeners, transactionListener);
    }

    protected final void clearAll() {
        this.clear();
        this._dirtyFieldIndexes = null;
        this._transactionListeners = null;
    }

    protected abstract void clear();

    public void close(boolean bl) {
        if (this.container() != null) {
            this.checkSynchronization();
            this.container().releaseSemaphores(this);
            if (this._referenceSystem != null) {
                this.container().referenceSystemRegistry().removeReferenceSystem(this._referenceSystem);
            }
        }
        if (bl) {
            this.rollback();
        }
    }

    public abstract void commit();

    protected void commit4FieldIndexes() {
        if (this._systemTransaction != null) {
            this._systemTransaction.commit4FieldIndexes();
        }
        if (this._dirtyFieldIndexes != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._dirtyFieldIndexes);
            while (iterator4Impl.moveNext()) {
                ((IndexTransaction)iterator4Impl.current()).commit();
            }
        }
    }

    protected void commitTransactionListeners() {
        this.checkSynchronization();
        if (this._transactionListeners != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._transactionListeners);
            while (iterator4Impl.moveNext()) {
                ((TransactionListener)iterator4Impl.current()).preCommit();
            }
            this._transactionListeners = null;
        }
    }

    public abstract boolean isDeleted(int var1);

    protected boolean isSystemTransaction() {
        return this._systemTransaction == null;
    }

    public boolean delete(ObjectReference objectReference, int n, int n2) {
        this.checkSynchronization();
        if (objectReference != null && !this._container.flagForDelete(objectReference)) {
            return false;
        }
        DeleteInfo deleteInfo = (DeleteInfo)TreeInt.find(this._delete, n);
        if (deleteInfo == null) {
            deleteInfo = new DeleteInfo(n, objectReference, n2);
            this._delete = Tree.add(this._delete, deleteInfo);
            return true;
        }
        deleteInfo._reference = objectReference;
        if (n2 > deleteInfo._cascade) {
            deleteInfo._cascade = n2;
        }
        return true;
    }

    public void dontDelete(int n) {
        if (this._delete == null) {
            return;
        }
        this._delete = TreeInt.removeLike((TreeInt)this._delete, n);
    }

    public HardObjectReference getHardReferenceBySignature(long l, byte[] byArray) {
        this.checkSynchronization();
        return this.container().uUIDIndex().getHardObjectReferenceBySignature(this, l, byArray);
    }

    public abstract void processDeletes();

    public ReferenceSystem referenceSystem() {
        if (this._referenceSystem != null) {
            return this._referenceSystem;
        }
        return this.parentTransaction().referenceSystem();
    }

    public Reflector reflector() {
        return this.container().reflector();
    }

    public abstract void rollback();

    protected void rollbackFieldIndexes() {
        if (this._dirtyFieldIndexes != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._dirtyFieldIndexes);
            while (iterator4Impl.moveNext()) {
                ((IndexTransaction)iterator4Impl.current()).rollback();
            }
        }
    }

    protected void rollBackTransactionListeners() {
        this.checkSynchronization();
        if (this._transactionListeners != null) {
            Iterator4Impl iterator4Impl = new Iterator4Impl(this._transactionListeners);
            while (iterator4Impl.moveNext()) {
                ((TransactionListener)iterator4Impl.current()).postRollback();
            }
            this._transactionListeners = null;
        }
    }

    public final void setPointer(Pointer4 pointer4) {
        this.setPointer(pointer4._id, pointer4._slot);
    }

    public void setPointer(int n, Slot slot) {
    }

    public void slotDelete(int n, Slot slot) {
    }

    public void slotFreeOnCommit(int n, Slot slot) {
    }

    public void slotFreeOnRollback(int n, Slot slot) {
    }

    void slotFreeOnRollbackCommitSetPointer(int n, Slot slot, boolean bl) {
    }

    void produceUpdateSlotChange(int n, Slot slot) {
    }

    public void slotFreePointerOnCommit(int n) {
    }

    void slotFreePointerOnCommit(int n, Slot slot) {
    }

    public void slotFreePointerOnRollback(int n) {
    }

    boolean supportsVirtualFields() {
        return true;
    }

    public Transaction systemTransaction() {
        if (this._systemTransaction != null) {
            return this._systemTransaction;
        }
        return this;
    }

    public String toString() {
        return this.container().toString();
    }

    public abstract void writeUpdateDeleteMembers(int var1, ClassMetadata var2, int var3, int var4);

    public final ObjectContainerBase container() {
        return this._container;
    }

    public Transaction parentTransaction() {
        return this._systemTransaction;
    }

    public void rollbackReferenceSystem() {
        this.referenceSystem().rollback();
    }

    public void commitReferenceSystem() {
        this.referenceSystem().commit();
    }

    public void addNewReference(ObjectReference objectReference) {
        this.referenceSystem().addNewReference(objectReference);
    }

    public final Object objectForIdFromCache(int n) {
        ObjectReference objectReference = this.referenceForId(n);
        if (objectReference == null) {
            return null;
        }
        Object object = objectReference.getObject();
        if (object == null) {
            this.removeReference(objectReference);
        }
        return object;
    }

    public final ObjectReference referenceForId(int n) {
        ObjectReference objectReference = this.referenceSystem().referenceForId(n);
        if (objectReference != null) {
            return objectReference;
        }
        if (this.parentTransaction() != null) {
            return this.parentTransaction().referenceForId(n);
        }
        return null;
    }

    public final ObjectReference referenceForObject(Object object) {
        ObjectReference objectReference = this.referenceSystem().referenceForObject(object);
        if (objectReference != null) {
            return objectReference;
        }
        if (this.parentTransaction() != null) {
            return this.parentTransaction().referenceForObject(object);
        }
        return null;
    }

    public final void removeReference(ObjectReference objectReference) {
        this.referenceSystem().removeReference(objectReference);
        objectReference.setID(-1);
        Platform4.killYapRef(objectReference.getObjectReference());
    }

    public final void removeObjectFromReferenceSystem(Object object) {
        ObjectReference objectReference = this.referenceForObject(object);
        if (objectReference != null) {
            this.removeReference(objectReference);
        }
    }

    public void setOutSideRepresentation(ObjectContainer objectContainer) {
        this._objectContainer = objectContainer;
    }

    public ObjectContainer objectContainer() {
        if (this._objectContainer != null) {
            return this._objectContainer;
        }
        return this._container;
    }

    public Context context() {
        return new Context(){

            public ObjectContainer objectContainer() {
                return Transaction.this.objectContainer();
            }

            public Transaction transaction() {
                return Transaction.this;
            }
        };
    }
}

