/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal;

import com.db4o.foundation.SimpleTimer;
import com.db4o.internal.ObjectContainerBase;
import com.db4o.internal.ObjectReference;
import com.db4o.internal.Platform4;
import com.db4o.internal.TransportObjectContainer;

class WeakReferenceCollector
implements Runnable {
    final Object _queue;
    private final ObjectContainerBase _stream;
    private SimpleTimer _timer;
    public final boolean _weak;

    WeakReferenceCollector(ObjectContainerBase objectContainerBase) {
        this._stream = objectContainerBase;
        this._weak = !(objectContainerBase instanceof TransportObjectContainer) && Platform4.hasWeakReferences() && objectContainerBase.configImpl().weakReferences();
        this._queue = this._weak ? Platform4.createReferenceQueue() : null;
    }

    Object createYapRef(ObjectReference objectReference, Object object) {
        if (!this._weak) {
            return object;
        }
        return Platform4.createActiveObjectReference(this._queue, objectReference, object);
    }

    void pollReferenceQueue() {
        if (!this._weak) {
            return;
        }
        Platform4.pollReferenceQueue(this._stream, this._queue);
    }

    public void run() {
        try {
            this.pollReferenceQueue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void startTimer() {
        if (!this._weak) {
            return;
        }
        if (!this._stream.configImpl().weakReferences()) {
            return;
        }
        if (this._stream.configImpl().weakReferenceCollectionInterval() <= 0) {
            return;
        }
        if (this._timer != null) {
            return;
        }
        this._timer = new SimpleTimer(this, this._stream.configImpl().weakReferenceCollectionInterval(), "db4o WeakReference collector");
        this._timer.start();
    }

    void stopTimer() {
        if (this._timer == null) {
            return;
        }
        this._timer.stop();
        this._timer = null;
    }
}

