/*
 * Decompiled with CFR 0.152.
 */
package jgnash;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Authenticator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import jgnash.engine.Engine;
import jgnash.engine.db4o.Db4oNetworkServer;
import jgnash.net.NetworkAuthenticator;
import jgnash.net.security.AbstractYahooParser;
import jgnash.ui.MainFrame;
import jgnash.ui.UIApplication;
import jgnash.ui.actions.OpenAction;
import jgnash.util.FileUtils;
import jgnash.util.OS;
import jgnash.util.Resource;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public final class Main {
    public static final String VERSION = Resource.getAppName() + " - " + Resource.getAppVersion();
    @Option(name="-opengl", usage="Enable OpenGL acceleration")
    private boolean opengl;
    @Option(name="-uninstall", usage="Remove registry settings")
    private boolean uninstall;
    @Option(name="-portable", usage="Enable portable preferences")
    private boolean portable;
    @Option(name="-portableFile", usage="Location for portable file")
    private String portableFile;
    @Option(name="-port", usage="Network port")
    private int port;
    @Option(name="-client", usage="Server host name or address")
    private String client;
    @Option(name="-file", usage="File to load at start")
    private File file;
    @Option(name="-server", usage="Act as a server using the specified file")
    private File server;
    @Option(name="-user", usage="Client or Server user name")
    private String user;
    @Option(name="-password", usage="Client or Server password")
    private String password;
    @Option(name="-enableEDT", usage="Check for EDT violations")
    private static boolean enableEDT;
    @Option(name="-verbose", usage="Enable verbose logging")
    private static boolean verbose;
    @Option(name="-enableHangDetect", usage="Enable hang detection on the EDT")
    private static boolean hangDetect;
    private static final int DEFAULT_PORT = 5300;
    private static final String DEFAULT_USER = "sa";
    private static final String DEFAULT_PASSWORD = "pass";

    public static boolean checkEDT() {
        return enableEDT;
    }

    public static boolean enableVerboseLogging() {
        return verbose;
    }

    public static boolean enableHangDetection() {
        return hangDetect;
    }

    private static boolean checkJVMVersion() {
        float version = Main.getJVMVersion();
        boolean result = true;
        System.out.println(version);
        if (version < 1.7f) {
            System.out.println(Resource.get().getString("Message.JVM7"));
            System.out.println(Resource.get().getString("Message.Version") + " " + System.getProperty("java.version") + "\n");
            JOptionPane.showMessageDialog(null, Resource.get().getString("Message.JVM7"), Resource.get().getString("Title.Error"), 0);
            result = false;
        }
        return result;
    }

    private static float getJVMVersion() {
        return Float.parseFloat(System.getProperty("java.version").substring(0, 3));
    }

    private static void configureLogging() {
        Handler[] handlers;
        for (Handler handler : handlers = Logger.getLogger("").getHandlers()) {
            handler.setLevel(Level.ALL);
        }
        Logger.getLogger(Engine.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(MainFrame.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(OpenAction.class.getName()).setLevel(Level.ALL);
        Logger.getLogger(AbstractYahooParser.class.getName()).setLevel(Level.ALL);
    }

    private static void enableAntialiasing() {
        System.out.println(Resource.get().getString("Message.Antialias"));
        System.setProperty("swing.aatext", "true");
    }

    public static void main(String[] args) {
        if (Main.checkJVMVersion()) {
            new Main(args);
        }
    }

    private static void setupNetworking() {
        Preferences auth = Preferences.userRoot().node("/jgnash/http");
        if (auth.getBoolean("useproxy", false)) {
            String proxyHost = auth.get("proxyhost", "");
            String proxyPort = auth.get("proxyport", "");
            System.getProperties().put("http.proxyHost", proxyHost);
            System.getProperties().put("http.proxyPort", proxyPort);
            Authenticator.setDefault(new NetworkAuthenticator());
            System.out.println(Resource.get().getString("Message.Proxy") + proxyHost + ":" + proxyPort);
        }
    }

    private static void deleteUserPreferences() {
        try {
            Preferences prefs = Preferences.userRoot();
            if (prefs.nodeExists("/jgnash")) {
                Preferences jgnash = prefs.node("/jgnash");
                jgnash.removeNode();
                prefs.flush();
            } else {
                System.err.println(Resource.get().getString("Message.PrefFail"));
            }
        }
        catch (BackingStoreException bse) {
            System.err.println(Resource.get().getString("Message.UninstallBad"));
        }
    }

    private Main(String[] args) {
        block22: {
            Main.configureLogging();
            CmdLineParser parser = new CmdLineParser((Object)this);
            try {
                parser.parseArgument(args);
                if (args.length == 1 && !args[0].startsWith("-")) {
                    File testFile = new File(args[0]);
                    if (testFile.exists()) {
                        this.file = testFile;
                    } else {
                        System.err.println(args[0] + " was not a valid file");
                    }
                }
                if (this.port <= 0) {
                    this.port = 5300;
                }
                if (this.user == null) {
                    this.user = DEFAULT_USER;
                }
                if (this.password == null) {
                    this.password = DEFAULT_PASSWORD;
                }
                if (this.uninstall) {
                    Main.deleteUserPreferences();
                    break block22;
                }
                if (this.server != null) {
                    try {
                        if (!FileUtils.isFileLocked(this.server.getAbsolutePath())) {
                            Db4oNetworkServer netserver = new Db4oNetworkServer();
                            netserver.runServer(this.server.getAbsolutePath(), this.port, this.user, this.password);
                            break block22;
                        }
                        System.err.println(Resource.get().getString("Message.FileIsLocked"));
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("File " + this.server.getAbsolutePath() + " was not found");
                    }
                    break block22;
                }
                if (this.portable || this.portableFile != null) {
                    System.setProperty("java.util.prefs.PreferencesFactory", "jgnash.util.prefs.MapPreferencesFactory");
                    try {
                        this.importPreferences();
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Preferences file " + this.getPreferenceFile().getAbsolutePath() + " was not found");
                    }
                    Runtime.getRuntime().addShutdownHook(new ExportPreferencesThread());
                }
                Main.enableAntialiasing();
                if (this.opengl) {
                    System.out.println(Resource.get().getString("Message.OpenGL"));
                    System.setProperty("sun.java2d.opengl", "True");
                }
                if (OS.isSystemOSX()) {
                    System.setProperty("apple.laf.useScreenMenuBar", "true");
                }
                Main.setupNetworking();
                if (this.client != null) {
                    new UIApplication(this.client, this.port, this.user, this.password);
                } else if (this.file != null && this.file.exists()) {
                    new UIApplication(this.file);
                } else {
                    new UIApplication(null);
                }
            }
            catch (CmdLineException e) {
                System.err.println(e.getMessage());
                parser.printUsage((OutputStream)System.err);
            }
        }
    }

    private File getPreferenceFile() {
        File exportFile;
        if (this.portableFile != null && !this.portableFile.isEmpty()) {
            exportFile = new File(this.portableFile);
        } else {
            String base = System.getProperty("user.dir");
            String filesep = System.getProperty("file.separator");
            exportFile = new File(base + filesep + "pref.xml");
        }
        return exportFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void importPreferences() throws FileNotFoundException {
        File importFile = this.getPreferenceFile();
        if (importFile.canRead()) {
            Logger.getLogger(Main.class.getName()).info("Importing preferences");
            FileInputStream is = new FileInputStream(importFile);
            try {
                Preferences.importPreferences(is);
            }
            catch (IOException | InvalidPreferencesFormatException e) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
            }
        }
    }

    private class ExportPreferencesThread
    extends Thread {
        private ExportPreferencesThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Logger.getLogger(Main.class.getName()).info("Exporting preferences");
            File exportFile = Main.this.getPreferenceFile();
            Preferences prefs = Preferences.userRoot();
            try {
                FileOutputStream os = new FileOutputStream(exportFile);
                try {
                    if (prefs.nodeExists("/jgnash")) {
                        Preferences p = prefs.node("/jgnash");
                        p.exportSubtree(os);
                    }
                    Main.deleteUserPreferences();
                }
                catch (IOException | BackingStoreException e) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                }
                finally {
                    try {
                        os.close();
                    }
                    catch (IOException e) {
                        Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
                    }
                }
            }
            catch (FileNotFoundException e) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

