/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import jgnash.engine.Account;
import jgnash.engine.MathConstants;
import jgnash.engine.budget.BudgetFactory;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.budget.BudgetPeriodDescriptor;
import jgnash.engine.budget.BudgetPeriodDescriptorFactory;
import jgnash.engine.budget.Pattern;
import jgnash.text.CommodityFormat;
import jgnash.ui.UIApplication;
import jgnash.ui.components.FormattedJTable;
import jgnash.ui.components.JFloatField;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.JTableUtils;
import jgnash.util.Resource;

public final class BudgetGoalDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger(BudgetGoalDialog.class.getName());
    private static final int SCROLLPANE_WIDTH = 120;
    private static final int SCROLLPANE_HEIGHT = 200;
    private final Resource rb = Resource.get();
    private JComboBox<BudgetPeriod> budgetPeriodCombo;
    private BudgetGoal budgetGoal;
    private JButton cancelButton;
    private JButton okButton;
    private JButton historicalButton;
    private JFloatField fillAmountField;
    private JButton fillButton;
    private boolean result = false;
    private PeriodTableModel model;
    private Account account;
    private int workingYear;
    private JComboBox<Pattern> patternComboBox;
    private JFloatField fillPatternAmountField;
    private JSpinner startRowSpinner;
    private JSpinner endRowSpinner;
    private JButton fillPatternEnterButton;

    public BudgetGoalDialog(Account account, BudgetGoal budgetGoal, int workingYear) {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.BudgetGoal") + " - " + account.getName());
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.setDefaultCloseOperation(2);
        this.workingYear = workingYear;
        this.account = account;
        if (budgetGoal == null) {
            throw new IllegalArgumentException("BudgetGoal may not be null");
        }
        try {
            this.budgetGoal = (BudgetGoal)budgetGoal.clone();
        }
        catch (CloneNotSupportedException e) {
            LOGGER.log(Level.SEVERE, e.toString(), e);
        }
        this.model = new PeriodTableModel(this.getDescriptors());
        this.layoutMainPanel();
    }

    private void layoutMainPanel() {
        FormLayout contentLayout = new FormLayout("fill:p:g, $lcgap, fill:p", "f:p:g, $ugap, f:p");
        JPanel contentPanel = new JPanel((LayoutManager)contentLayout);
        DefaultFormBuilder contentBuilder = new DefaultFormBuilder(contentLayout, contentPanel);
        contentBuilder.setDefaultDialogBorder();
        FormLayout layout = new FormLayout("right:d, $lcgap, fill:p:g", "f:p, $rgap, d, $ugap, f:p:g");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.historicalButton = new JButton(this.rb.getString("Button.HistoricalFill"));
        this.fillAmountField = new JFloatField(this.account.getCurrencyNode());
        this.fillAmountField.setDecimal(BigDecimal.ZERO);
        this.fillPatternAmountField = new JFloatField(this.account.getCurrencyNode());
        this.fillPatternAmountField.setDecimal(BigDecimal.ZERO);
        this.fillButton = new JButton(this.rb.getString("Button.Enter"));
        this.fillPatternEnterButton = new JButton(this.rb.getString("Button.Enter"));
        this.budgetPeriodCombo = new JComboBox();
        this.budgetPeriodCombo.setModel(new DefaultComboBoxModel<BudgetPeriod>(BudgetPeriod.values()));
        this.budgetPeriodCombo.setSelectedItem((Object)this.getBudgetGoal().getBudgetPeriod());
        this.patternComboBox = new JComboBox();
        this.patternComboBox.setModel(new DefaultComboBoxModel<Pattern>(Pattern.values()));
        int max = this.getDescriptors().size();
        this.startRowSpinner = new JSpinner(new SpinnerNumberModel(1, 1, max, 1));
        this.endRowSpinner = new JSpinner(new SpinnerNumberModel(max, 1, max, 1));
        builder.append((Component)new JLabel(this.rb.getString("Label.Period")), this.budgetPeriodCombo);
        builder.nextLine();
        builder.nextLine();
        builder.append((Component)new JLabel(this.rb.getString("Label.Currency")), (Component)new JLabel(this.account.getCurrencyNode().getSymbol()));
        builder.nextLine();
        builder.nextLine();
        GoalTable table = new GoalTable(this.model);
        table.getSelectionModel().setSelectionMode(0);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        ToolTipManager.sharedInstance().unregisterComponent(table);
        JScrollPane scrollPane = new JScrollPane(table);
        scrollPane.setPreferredSize(new Dimension(120, 200));
        builder.append((Component)scrollPane, 3);
        JPanel patternPanel = new JPanel();
        patternPanel.setLayout((LayoutManager)new FormLayout(new ColumnSpec[]{FormFactory.DEFAULT_COLSPEC, FormFactory.RELATED_GAP_COLSPEC, ColumnSpec.decode((String)"default:grow")}, new RowSpec[]{FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC, FormFactory.RELATED_GAP_ROWSPEC, FormFactory.DEFAULT_ROWSPEC}));
        patternPanel.add((Component)new JLabel(this.rb.getString("Label.Pattern")), "1, 2, right, default");
        patternPanel.add(this.patternComboBox, "3, 2, fill, default");
        patternPanel.add((Component)new JLabel(this.rb.getString("Label.StartRow")), "1, 4, right, default");
        patternPanel.add((Component)this.startRowSpinner, "3, 4");
        patternPanel.add((Component)new JLabel(this.rb.getString("Label.EndRow")), "1, 6, right, default");
        patternPanel.add((Component)this.endRowSpinner, "3, 6");
        patternPanel.add((Component)new JLabel(this.rb.getString("Label.Amount")), "1, 8, right, default");
        patternPanel.add((Component)this.fillPatternAmountField, "3, 8, fill, default");
        patternPanel.add((Component)ButtonBarFactory.buildOKBar((JButton)this.fillPatternEnterButton), "3, 10");
        FormLayout fillLayout = new FormLayout("right:d, $lcgap, fill:max(48dlu;min):g, $lcgap, d", "d, $rgap, d, $rgap, d, $rgap, d, $rgap, d");
        DefaultFormBuilder fillBuilder = new DefaultFormBuilder(fillLayout);
        fillBuilder.setBorder((Border)new TitledBorder(this.rb.getString("Title.SmartFill")));
        fillBuilder.append((Component)this.historicalButton, 5);
        fillBuilder.nextLine();
        fillBuilder.nextLine();
        fillBuilder.appendSeparator();
        fillBuilder.nextLine();
        fillBuilder.nextLine();
        fillBuilder.append((Component)new JLabel(this.rb.getString("Label.FillAll")), (Component)this.fillAmountField, (Component)this.fillButton);
        fillBuilder.nextLine();
        fillBuilder.nextLine();
        fillBuilder.appendSeparator();
        fillBuilder.nextLine();
        fillBuilder.nextLine();
        fillBuilder.append((Component)patternPanel, 5);
        this.budgetPeriodCombo.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.historicalButton.addActionListener(this);
        this.fillButton.addActionListener(this);
        this.fillPatternEnterButton.addActionListener(this);
        contentBuilder.append((Component)builder.getPanel(), (Component)fillBuilder.getPanel());
        contentBuilder.nextLine();
        contentBuilder.nextLine();
        contentBuilder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(contentBuilder.getPanel());
        this.pack();
        this.setMinimumSize(this.getSize());
        DialogUtils.addBoundsListener(this);
        JTableUtils.packGenericTable(table);
    }

    public BudgetGoal getBudgetGoal() {
        return this.budgetGoal;
    }

    public boolean getResult() {
        return this.result;
    }

    private void updatePeriod() {
        BudgetPeriod period = (BudgetPeriod)((Object)this.budgetPeriodCombo.getSelectedItem());
        this.getBudgetGoal().setBudgetPeriod(period);
        this.model.updateDescriptors(this.getDescriptors());
        int max = this.getDescriptors().size();
        this.startRowSpinner.setModel(new SpinnerNumberModel(1, 1, max, 1));
        this.endRowSpinner.setModel(new SpinnerNumberModel(max, 1, max, 1));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.result = false;
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.okButton) {
            this.result = true;
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.budgetPeriodCombo) {
            this.updatePeriod();
        } else if (e.getSource() == this.historicalButton) {
            this.performHistoricalImport();
        } else if (e.getSource() == this.fillButton) {
            this.performFillAction();
        } else if (e.getSource() == this.fillPatternEnterButton) {
            this.performFillPatternAction();
        }
    }

    private List<BudgetPeriodDescriptor> getDescriptors() {
        return BudgetPeriodDescriptorFactory.getDescriptors(this.workingYear, this.budgetGoal.getBudgetPeriod());
    }

    private void performFillPatternAction() {
        BigDecimal fillAmount = this.fillPatternAmountField.getDecimal();
        int startRow = (Integer)this.startRowSpinner.getValue() - 1;
        int endRow = (Integer)this.endRowSpinner.getValue() - 1;
        Pattern pattern = this.patternComboBox.getItemAt(this.patternComboBox.getSelectedIndex());
        this.budgetGoal = BudgetFactory.buildBudgetGoal(this.budgetGoal, this.account, this.getDescriptors(), pattern, startRow, endRow, fillAmount);
        this.model.fireTableDataChanged();
    }

    private void performHistoricalImport() {
        this.budgetGoal = BudgetFactory.buildAverageBudgetGoal(this.account, this.getDescriptors(), true);
        this.model.fireTableDataChanged();
    }

    private void performFillAction() {
        BigDecimal fillAmount = this.fillAmountField.getDecimal();
        for (BudgetPeriodDescriptor descriptor : this.getDescriptors()) {
            this.budgetGoal.setGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod(), fillAmount);
        }
        this.model.fireTableDataChanged();
    }

    private class GoalTable
    extends FormattedJTable {
        private NumberFormat commodityFormatter;

        public GoalTable(TableModel model) {
            super(model);
            this.commodityFormatter = CommodityFormat.getShortNumberFormat(BudgetGoalDialog.this.account.getCurrencyNode());
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            if (column == 1) {
                ((JLabel)c).setText(this.commodityFormatter.format(this.getModel().getValueAt(row, column)));
            }
            ((JLabel)c).setText(this.getModel().getValueAt(row, column).toString());
            return c;
        }
    }

    class PeriodTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private List<BudgetPeriodDescriptor> periodDescriptors;
        private String[] columnNames;

        public PeriodTableModel(List<BudgetPeriodDescriptor> descriptors) {
            this.columnNames = new String[]{BudgetGoalDialog.this.rb.getString("Column.Period"), BudgetGoalDialog.this.rb.getString("Column.Amount")};
            this.periodDescriptors = descriptors;
        }

        void updateDescriptors(List<BudgetPeriodDescriptor> descriptors) {
            this.periodDescriptors = descriptors;
            this.fireTableDataChanged();
        }

        @Override
        public int getRowCount() {
            return this.periodDescriptors.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.columnNames[columnIndex];
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            BudgetPeriodDescriptor descriptor = this.periodDescriptors.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return descriptor.getPeriodDescription();
                }
                case 1: {
                    BigDecimal goal = BudgetGoalDialog.this.budgetGoal.getGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod());
                    return goal.setScale((int)BudgetGoalDialog.this.account.getCurrencyNode().getScale(), MathConstants.roundingMode);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return BigDecimal.class;
                }
            }
            return String.class;
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            try {
                BigDecimal amount = new BigDecimal(value.toString());
                BudgetPeriodDescriptor descriptor = this.periodDescriptors.get(rowIndex);
                BudgetGoalDialog.this.budgetGoal.setGoal(descriptor.getStartPeriod(), descriptor.getEndPeriod(), amount);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, e.toString(), e);
            }
        }
    }
}

