/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.ButtonStackBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.ui.UIApplication;
import jgnash.ui.budget.BudgetWizardDialog;
import jgnash.ui.budget.RenameBudgetDialog;
import jgnash.ui.components.SortedListModel;
import jgnash.ui.components.YesNoDialog;
import jgnash.ui.util.DialogUtils;
import jgnash.util.Resource;

public final class BudgetManagerDialog
extends JDialog
implements ActionListener,
MessageListener {
    private final Resource rb = Resource.get();
    private JButton closeButton;
    private JButton newAutoButton;
    private JButton newButton;
    private JButton duplicateButton;
    private JButton deleteButton;
    private JButton renameButton;
    private JList<BudgetObject> budgetList;

    public static void showDialog() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BudgetManagerDialog d = new BudgetManagerDialog();
                DialogUtils.addBoundsListener(d);
                d.setVisible(true);
            }
        });
    }

    private BudgetManagerDialog() {
        super((Frame)UIApplication.getFrame(), true);
        this.setTitle(this.rb.getString("Title.BudgetManager"));
        this.setIconImage(Resource.getImage("/jgnash/resource/gnome-money.png"));
        this.setDefaultCloseOperation(2);
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.deleteButton = new JButton(this.rb.getString("Button.Delete"));
        this.duplicateButton = new JButton(this.rb.getString("Button.Duplicate"));
        this.newAutoButton = new JButton(this.rb.getString("Button.NewHist"));
        this.newButton = new JButton(this.rb.getString("Button.NewEmpty"));
        this.renameButton = new JButton(this.rb.getString("Button.Rename"));
        this.budgetList = new JList();
        this.buildBudgetModel();
        this.closeButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.duplicateButton.addActionListener(this);
        this.newAutoButton.addActionListener(this);
        this.newButton.addActionListener(this);
        this.renameButton.addActionListener(this);
        MessageBus.getInstance().registerListener(this, MessageChannel.BUDGET);
    }

    private void layoutMainPanel() {
        this.initComponents();
        ButtonStackBuilder buttonStackBuilder = new ButtonStackBuilder();
        buttonStackBuilder.addButton(new JButton[]{this.newAutoButton, this.newButton, this.duplicateButton, this.renameButton});
        buttonStackBuilder.addUnrelatedGap();
        buttonStackBuilder.addButton(new JButton[]{this.deleteButton});
        FormLayout layout = new FormLayout("p:g, $lcgap, f:p", "f:max(35dlu;p):g, $ugap, p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.add((Component)new JScrollPane(this.budgetList), cc.xy(1, 1));
        builder.add((Component)buttonStackBuilder.getPanel(), cc.xy(3, 1));
        builder.add((Component)ButtonBarFactory.buildCloseBar((JButton)this.closeButton), cc.xyw(1, 3, 3));
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private void buildBudgetModel() {
        final SortedListModel<BudgetObject> model = new SortedListModel<BudgetObject>();
        Engine e = EngineFactory.getEngine("default");
        for (Budget budget : e.getBudgetList()) {
            model.addElement(new BudgetObject(budget));
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BudgetManagerDialog.this.budgetList.setModel(model);
            }
        });
    }

    @Override
    public void actionPerformed(final ActionEvent e) {
        if (e.getSource() == this.closeButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (e.getSource() == BudgetManagerDialog.this.newButton) {
                    BudgetManagerDialog.this.createNewBudget();
                } else if (e.getSource() == BudgetManagerDialog.this.deleteButton) {
                    BudgetManagerDialog.this.deleteBudget();
                } else if (e.getSource() == BudgetManagerDialog.this.duplicateButton) {
                    BudgetManagerDialog.this.cloneBudget();
                } else if (e.getSource() == BudgetManagerDialog.this.renameButton) {
                    BudgetManagerDialog.this.renameBudget();
                } else if (e.getSource() == BudgetManagerDialog.this.newAutoButton) {
                    BudgetManagerDialog.this.createNewAutoBudget();
                }
            }
        });
    }

    private void renameBudget() {
        for (BudgetObject o : this.budgetList.getSelectedValuesList()) {
            RenameBudgetDialog.showDialog(o.getBudget(), this);
        }
    }

    private void createNewAutoBudget() {
        BudgetWizardDialog.showDialog();
    }

    private void createNewBudget() {
        boolean nameIsUnique;
        Engine e = EngineFactory.getEngine("default");
        Budget newBudget = new Budget();
        String name = this.rb.getString("Word.NewBudget");
        int count = 2;
        do {
            nameIsUnique = true;
            for (Budget budget : e.getBudgetList()) {
                if (!budget.getName().equals(name)) continue;
                name = this.rb.getString("Word.NewBudget") + " " + count;
                ++count;
                nameIsUnique = false;
            }
        } while (!nameIsUnique);
        newBudget.setName(name);
        newBudget.setDescription(this.rb.getString("Word.NewBudget"));
        e.addBudget(newBudget);
    }

    private void deleteBudget() {
        Engine e = EngineFactory.getEngine("default");
        List<BudgetObject> values = this.budgetList.getSelectedValuesList();
        if (values.size() > 0) {
            String message;
            String string = message = values.size() == 1 ? this.rb.getString("Message.ConfirmBudgetDelete") : this.rb.getString("Message.ConfirmMultipleBudgetDelete");
            if (YesNoDialog.showYesNoDialog(UIApplication.getFrame(), new JLabel(this.rb.getString(message)), this.rb.getString("Title.Confirm"))) {
                for (BudgetObject value : values) {
                    e.removeBudget(value.getBudget());
                }
            }
        }
    }

    private void cloneBudget() {
        Engine e = EngineFactory.getEngine("default");
        for (BudgetObject value : this.budgetList.getSelectedValuesList()) {
            try {
                Budget newBudget = (Budget)value.getBudget().clone();
                e.addBudget(newBudget);
            }
            catch (CloneNotSupportedException e1) {
                Logger.getLogger(BudgetManagerDialog.class.getName()).log(Level.SEVERE, e1.toString(), e1);
            }
        }
    }

    @Override
    public void messagePosted(Message event) {
        if (event.getEvent() == ChannelEvent.BUDGET_ADD || event.getEvent() == ChannelEvent.BUDGET_REMOVE || event.getEvent() == ChannelEvent.BUDGET_UPDATE) {
            this.buildBudgetModel();
        }
    }

    private static final class BudgetObject
    implements Comparable<BudgetObject> {
        private Budget budget;

        public BudgetObject(Budget budget) {
            this.setBudget(budget);
        }

        public String toString() {
            return this.getBudget().getName();
        }

        @Override
        public int compareTo(BudgetObject o) {
            return this.getBudget().compareTo(o.getBudget());
        }

        public boolean equals(Object o) {
            boolean equal = false;
            if (o instanceof BudgetObject) {
                equal = this.getBudget().equals(((BudgetObject)o).getBudget());
            }
            return equal;
        }

        public Budget getBudget() {
            return this.budget;
        }

        public void setBudget(Budget budget) {
            this.budget = budget;
        }

        public int hashCode() {
            return this.getBudget().hashCode();
        }
    }
}

