/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.budget;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTextField;
import jgnash.engine.EngineFactory;
import jgnash.engine.budget.Budget;
import jgnash.ui.util.DialogUtils;
import jgnash.ui.util.ValidationFactory;
import jgnash.util.Resource;

class RenameBudgetDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private final Resource rb = Resource.get();
    private JButton okButton;
    private JButton cancelButton;
    private JTextField budgetNameField;
    private Budget budget;

    public static void showDialog(final Budget budget, final Dialog parent) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RenameBudgetDialog d = new RenameBudgetDialog(budget, parent);
                DialogUtils.addBoundsListener(d);
                d.setLocationRelativeTo(parent);
                d.setVisible(true);
            }
        });
    }

    public RenameBudgetDialog(Budget budget, Dialog parent) {
        super(parent, true);
        this.setTitle(this.rb.getString("Title.RenameBudget"));
        this.setDefaultCloseOperation(2);
        if (budget == null) {
            throw new IllegalArgumentException("budget may not be null");
        }
        this.budget = budget;
        this.layoutMainPanel();
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("p, $lcgap, fill:100dlu:g", "f:p:g, $ugap, f:p");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.append((Component)new JLabel(this.rb.getString("Label.RenameBudget")), (Component)ValidationFactory.wrap(this.budgetNameField));
        builder.nextRow();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.okButton, (JButton)this.cancelButton), 3);
        this.getContentPane().add(builder.getPanel());
        this.pack();
    }

    private void initComponents() {
        this.okButton = new JButton(this.rb.getString("Button.Ok"));
        this.cancelButton = new JButton(this.rb.getString("Button.Cancel"));
        this.budgetNameField = new JTextField(this.budget.getName());
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.okButton) {
            if (this.budgetNameField.getText().length() > 0) {
                this.budget.setName(this.budgetNameField.getText());
                EngineFactory.getEngine("default").updateBudget(this.budget);
                this.dispatchEvent(new WindowEvent(this, 201));
            } else {
                ValidationFactory.showValidationError(this.rb.getString("Message.Error.Empty"), this.budgetNameField);
            }
        }
    }
}

