/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.checks;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.print.PageFormat;
import java.text.DecimalFormat;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import jgnash.engine.checks.CheckLayout;
import jgnash.engine.checks.CheckLayoutSerializationFactory;
import jgnash.engine.checks.CheckObject;
import jgnash.ui.checks.PrintPreviewPanel;
import jgnash.ui.checks.PrintableCheckLayout;
import jgnash.ui.components.JTextFieldEx;
import jgnash.ui.components.RollOverButton;
import jgnash.util.Resource;

public class CheckDesignDialog
extends JDialog
implements ActionListener,
ListSelectionListener,
FocusListener {
    private PrintPreviewPanel previewPanel;
    private DefaultListModel<CheckObject> model;
    private JFormattedTextField xPosField;
    private JFormattedTextField yPosField;
    private JFormattedTextField heightField;
    private JFormattedTextField countField;
    private JButton addButton;
    private JButton applyButton;
    private JButton clearButton;
    private JButton closeButton;
    private JTextField nameField;
    private JList<CheckObject> objectList;
    private JButton openButton;
    private JButton printButton;
    private JButton removeButton;
    private JButton saveButton;
    private JButton setupButton;
    private JToolBar toolBar;
    private JComboBox<CheckObject.CheckObjectType> typeCombo;
    private CheckObject activeObject = null;
    private CheckLayout checkLayout;
    private PrintableCheckLayout layout;
    private final Preferences pref = Preferences.userNodeForPackage(CheckDesignDialog.class);
    private final Resource rb = Resource.get();
    private static final String CURRENT_DIR = "cwd";

    public CheckDesignDialog(Frame parent) {
        super(parent, true);
        this.setDefaultCloseOperation(2);
        this.setTitle(this.rb.getString("Title.CheckDesign"));
        this.layoutMainPanel();
        this.setLocationRelativeTo(parent);
        this.clear();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new CheckDesignDialog(null).setVisible(true);
            }
        });
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.toolBar.setRollover(true);
        this.openButton = new RollOverButton(this.rb.getString("Menu.Open.Name"), Resource.getIcon("/jgnash/resource/document-open.png"));
        this.openButton.setMnemonic(this.rb.getMnemonic("Menu.Open.Mnemonic"));
        this.saveButton = new RollOverButton(this.rb.getString("Menu.Save.Name"), Resource.getIcon("/jgnash/resource/document-save.png"));
        this.saveButton.setMnemonic(this.rb.getMnemonic("Menu.Save.Mnemonic"));
        this.toolBar.add(this.openButton);
        this.toolBar.add(this.saveButton);
        this.checkLayout = new CheckLayout();
        this.layout = new PrintableCheckLayout(this.checkLayout);
        this.countField = CheckDesignDialog.getIntegerField();
        this.xPosField = CheckDesignDialog.getFloatField();
        this.yPosField = CheckDesignDialog.getFloatField();
        this.heightField = CheckDesignDialog.getFloatField();
        this.previewPanel = new PrintPreviewPanel(this.layout, this.layout.getPageFormat());
        this.objectList = new JList();
        this.setupButton = new JButton(this.rb.getString("Button.PageSetup"));
        this.addButton = new JButton(this.rb.getString("Button.Add"));
        this.removeButton = new JButton(this.rb.getString("Button.Remove"));
        this.clearButton = new JButton(this.rb.getString("Button.Clear"));
        this.applyButton = new JButton(this.rb.getString("Button.Apply"));
        this.printButton = new JButton(this.rb.getString("Button.PrintSample"));
        this.closeButton = new JButton(this.rb.getString("Button.Close"));
        this.nameField = new JTextFieldEx();
        this.typeCombo = new JComboBox();
        DefaultComboBoxModel<CheckObject.CheckObjectType> comboModel = new DefaultComboBoxModel<CheckObject.CheckObjectType>(CheckObject.CheckObjectType.values());
        this.typeCombo.setModel(comboModel);
        this.model = new DefaultListModel();
        this.objectList.setModel(this.model);
        this.objectList.addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.countField.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.setupButton.addActionListener(this);
        this.heightField.addActionListener(this);
        this.saveButton.addActionListener(this);
        this.openButton.addActionListener(this);
        this.printButton.addActionListener(this);
        this.heightField.addFocusListener(this);
        this.countField.addFocusListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        this.getContentPane().add((Component)this.toolBar, "North");
        FormLayout formLayout = new FormLayout("p:g, 8dlu, f:$lcgap, 8dlu, p", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout);
        builder.setDefaultDialogBorder();
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)this.buildLeftPanel());
        builder.append((Component)new JSeparator(1));
        builder.append((Component)this.buildRightPanel());
        builder.appendSeparator();
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildHelpCloseBar((JButton)this.printButton, (JButton)this.closeButton), 5);
        this.getContentPane().add((Component)builder.getPanel(), "Center");
        this.pack();
        this.setMinimumSize(this.getSize());
    }

    private JPanel buildRightPanel() {
        FormLayout formLayout = new FormLayout("right:p, $lcgap, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout);
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)new JScrollPane(this.objectList), 3);
        builder.append((Component)ButtonBarFactory.buildAddRemoveBar((JButton)this.addButton, (JButton)this.removeButton), 3);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.Type"), this.typeCombo);
        builder.append(this.rb.getString("Label.Name"), (Component)this.nameField);
        builder.append(this.rb.getString("Label.XPos"), (Component)this.xPosField);
        builder.append(this.rb.getString("Label.YPos"), (Component)this.yPosField);
        builder.setRowGroupingEnabled(false);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)ButtonBarFactory.buildOKCancelBar((JButton)this.clearButton, (JButton)this.applyButton), 3);
        return builder.getPanel();
    }

    private JPanel buildLeftPanel() {
        FormLayout formLayout = new FormLayout("p, $lcgap, max(55dlu;p):g(0.5), 8dlu, p, $lcgap, max(55dlu;p):g(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(formLayout);
        builder.appendRow(RowSpec.decode((String)"f:p:g"));
        builder.append((Component)this.previewPanel, 7);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append(this.rb.getString("Label.Height"), (Component)this.heightField);
        builder.append(this.rb.getString("Label.Count"), (Component)this.countField);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.setupButton, 4);
        return builder.getPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.applyButton) {
            this.applyChanges();
        } else if (e.getSource() == this.addButton) {
            this.addObject();
        } else if (e.getSource() == this.removeButton) {
            this.removeObject();
        } else if (e.getSource() == this.clearButton) {
            this.clear();
        } else if (e.getSource() == this.closeButton) {
            this.dispatchEvent(new WindowEvent(this, 201));
        } else if (e.getSource() == this.setupButton) {
            this.pageSetup();
        } else if (e.getSource() == this.heightField) {
            this.updateHeight();
        } else if (e.getSource() == this.countField) {
            this.updateCount();
        } else if (e.getSource() == this.printButton) {
            this.printSample();
        } else if (e.getSource() == this.saveButton) {
            this.saveLayout();
        } else if (e.getSource() == this.openButton) {
            this.openLayout();
        }
    }

    private void saveLayout() {
        String fn = null;
        JFileChooser chooser = CheckDesignDialog.createFileChooser(this.pref.get(CURRENT_DIR, null));
        if (chooser.showSaveDialog(this) == 0) {
            this.pref.put(CURRENT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            fn = chooser.getSelectedFile().getAbsolutePath();
            if (!fn.endsWith(".lay.xml")) {
                fn = !fn.endsWith(".lay") ? fn + ".lay.xml" : fn + ".xml";
            }
        }
        if (fn != null) {
            CheckLayoutSerializationFactory.saveLayout(fn, this.layout.getCheckLayout());
        }
    }

    private void openLayout() {
        CheckLayout o;
        JFileChooser chooser = CheckDesignDialog.createFileChooser(this.pref.get(CURRENT_DIR, null));
        String fn = null;
        if (chooser.showOpenDialog(this) == 0) {
            this.pref.put(CURRENT_DIR, chooser.getCurrentDirectory().getAbsolutePath());
            fn = chooser.getSelectedFile().getAbsolutePath();
        }
        if (fn != null && (o = CheckLayoutSerializationFactory.loadLayout(fn)) != null) {
            this.checkLayout = o;
            this.layout.setCheckLayout(this.checkLayout);
            this.layout.setTestPrint(true);
            this.loadModel();
            this.previewPanel.setPrintable(this.layout);
            this.clear();
        }
    }

    private void loadModel() {
        this.model.removeAllElements();
        for (CheckObject object : this.layout.getCheckObjects()) {
            this.model.addElement(object);
        }
    }

    private static JFileChooser createFileChooser(String dir) {
        JFileChooser chooser = new JFileChooser(dir);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("jGnash Files(*.xml)", "xml"));
        return chooser;
    }

    private void pageSetup() {
        PageFormat pageFormat = this.layout.pageSetup();
        if (pageFormat != null) {
            this.previewPanel.setPageFormat(pageFormat);
        }
    }

    private void printSample() {
        this.layout.print();
    }

    private void applyChanges() {
        if (this.activeObject != null) {
            CheckObject o = this.activeObject;
            int index = this.objectList.getSelectedIndex();
            this.model.remove(index);
            o.setName(this.nameField.getText());
            o.setX(Float.parseFloat(this.xPosField.getText()));
            o.setY(Float.parseFloat(this.yPosField.getText()));
            o.setType((CheckObject.CheckObjectType)((Object)this.typeCombo.getSelectedItem()));
            this.model.insertElementAt(o, index);
            this.clear();
            this.previewPanel.repaint();
        } else {
            this.addObject();
        }
    }

    private void showObject() {
        this.activeObject = this.objectList.getSelectedValue();
        if (this.activeObject != null) {
            this.typeCombo.setSelectedItem((Object)this.activeObject.getType());
            this.nameField.setText(this.activeObject.getName());
            this.xPosField.setText(Float.toString(this.activeObject.getX()));
            this.yPosField.setText(Float.toString(this.activeObject.getY()));
        }
    }

    private void addObject() {
        if (this.activeObject == null) {
            CheckObject o = new CheckObject();
            if (this.nameField.getText().length() > 0) {
                o.setName(this.nameField.getText());
            }
            if (this.xPosField.getText().length() > 0) {
                o.setX(Float.parseFloat(this.xPosField.getText()));
            }
            if (this.yPosField.getText().length() > 0) {
                o.setY(Float.parseFloat(this.yPosField.getText()));
            }
            o.setType((CheckObject.CheckObjectType)((Object)this.typeCombo.getSelectedItem()));
            this.model.addElement(o);
            this.checkLayout.add(o);
            this.previewPanel.repaint();
        }
    }

    private void clear() {
        this.nameField.setText("");
        this.xPosField.setText("0.0");
        this.yPosField.setText("0.0");
        this.countField.setText(Integer.toString(this.layout.getNumChecks()));
        this.heightField.setText(Double.toString(this.layout.getCheckHeight()));
        this.previewPanel.setPageFormat(this.layout.getPageFormat());
        this.activeObject = null;
    }

    private void removeObject() {
        if (this.activeObject != null) {
            this.checkLayout.remove(this.activeObject);
            this.model.removeElement(this.activeObject);
            this.previewPanel.repaint();
            this.clear();
        }
    }

    private void updateHeight() {
        if (this.heightField.getText().length() > 0) {
            this.checkLayout.setCheckHeight(Float.parseFloat(this.heightField.getText()));
            this.previewPanel.repaint();
        }
    }

    private void updateCount() {
        if (this.countField.getText().length() > 0) {
            this.layout.setNumChecks(Integer.parseInt(this.countField.getText()));
            this.previewPanel.repaint();
        }
    }

    private static JFormattedTextField getFloatField() {
        NumberFormatter df = new NumberFormatter(new DecimalFormat("#.##"));
        NumberFormatter ef = new NumberFormatter(new DecimalFormat("#.##"));
        return new JFormattedTextField(new DefaultFormatterFactory(df, df, ef));
    }

    private static JFormattedTextField getIntegerField() {
        NumberFormatter df = new NumberFormatter(new DecimalFormat("#"));
        NumberFormatter ef = new NumberFormatter(new DecimalFormat("#"));
        return new JFormattedTextField(new DefaultFormatterFactory(df, df, ef));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.showObject();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void focusLost(FocusEvent e) {
        if (e.getSource() == this.heightField) {
            this.updateHeight();
        } else if (e.getSource() == this.countField) {
            this.updateCount();
        }
    }
}

