/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.recurring;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import jgnash.engine.recurring.DailyReminder;
import jgnash.engine.recurring.Reminder;
import jgnash.ui.components.DatePanel;
import jgnash.ui.recurring.RecurringTab;
import jgnash.util.Resource;

public class DayTab
extends JPanel
implements RecurringTab,
ActionListener {
    private JRadioButton noEndButton;
    private JRadioButton endButton;
    private JSpinner numberSpinner;
    private DatePanel endDateField;
    private final Resource rb = Resource.get();
    private ButtonGroup group = new ButtonGroup();
    private Reminder reminder = new DailyReminder();

    public DayTab() {
        this.layoutMainPanel();
        this.noEndButton.addActionListener(this);
        this.endButton.addActionListener(this);
        this.noEndButton.setSelected(true);
        this.updateForm();
    }

    private void layoutMainPanel() {
        FormLayout layout = new FormLayout("right:p, $lcgap, f:p, 2dlu, max(48dlu;min), 2dlu, f:p", "f:p, $lgap, f:p, $lgap, f:p");
        layout.setRowGroups((int[][])new int[][]{{1, 3, 5}});
        this.setLayout((LayoutManager)layout);
        this.setBorder(Borders.DIALOG_BORDER);
        CellConstraints cc = new CellConstraints();
        this.noEndButton = new JRadioButton(this.rb.getString("Button.NoEndDate"));
        this.endButton = new JRadioButton();
        this.endDateField = new DatePanel();
        this.group.add(this.noEndButton);
        this.group.add(this.endButton);
        this.numberSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 365, 1));
        this.add((Component)new JLabel(this.rb.getString("Label.Every")), cc.xy(1, 1));
        this.add((Component)this.numberSpinner, cc.xywh(3, 1, 3, 1));
        this.add((Component)new JLabel(this.rb.getString("Tab.Day")), cc.xy(7, 1));
        this.add((Component)new JLabel(this.rb.getString("Label.EndOn")), cc.xy(1, 3));
        this.add((Component)this.noEndButton, cc.xywh(3, 3, 5, 1));
        this.add((Component)this.endButton, cc.xy(3, 5));
        this.add((Component)this.endDateField, cc.xy(5, 5));
    }

    private void updateForm() {
        this.endDateField.setEnabled(this.endButton.isSelected());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.noEndButton || e.getSource() == this.endButton) {
            this.updateForm();
        }
    }

    @Override
    public Reminder getReminder() {
        DailyReminder r = (DailyReminder)this.reminder;
        int inc = ((Number)this.numberSpinner.getValue()).intValue();
        Date endDate = null;
        if (this.endButton.isSelected()) {
            endDate = this.endDateField.getDate();
        }
        r.setIncrement(inc);
        r.setEndDate(endDate);
        return this.reminder;
    }

    @Override
    public void setReminder(Reminder reminder) {
        assert (reminder instanceof DailyReminder);
        this.reminder = reminder;
        DailyReminder r = (DailyReminder)reminder;
        this.numberSpinner.setValue(r.getIncrement());
        if (r.getEndDate() != null) {
            this.endDateField.setDate(r.getEndDate());
            this.endButton.setSelected(true);
        }
        this.updateForm();
    }
}

