/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountType;
import jgnash.ui.register.AccountBalanceDisplayMode;

public class AccountBalanceDisplayManager {
    private static AccountBalanceDisplayMode accountBalanceDisplayingMode;
    private static final String ACCOUNT_BALANCE_DISPLAY_MODE = "accountbalancedisplayingmode";
    private static List<WeakReference<ActionListener>> actionListeners;

    private AccountBalanceDisplayManager() {
    }

    private static BigDecimal reverseCredit(AccountType accountType, BigDecimal balance) {
        if (accountType.getAccountGroup() == AccountGroup.EQUITY || accountType.getAccountGroup() == AccountGroup.INCOME || accountType.getAccountGroup() == AccountGroup.LIABILITY) {
            return balance.negate();
        }
        return balance;
    }

    private static BigDecimal reverseIncomeAndExpense(AccountType accountType, BigDecimal balance) {
        if (accountType.getAccountGroup() == AccountGroup.INCOME || accountType.getAccountGroup() == AccountGroup.EXPENSE) {
            return balance.negate();
        }
        return balance;
    }

    public static BigDecimal convertToSelectedBalanceMode(AccountType accountType, BigDecimal balance) {
        if (AccountBalanceDisplayManager.getDisplayMode() == AccountBalanceDisplayMode.NONE) {
            return balance;
        }
        if (AccountBalanceDisplayManager.getDisplayMode() == AccountBalanceDisplayMode.REVERSE_INCOME_EXPENSE) {
            return AccountBalanceDisplayManager.reverseIncomeAndExpense(accountType, balance);
        }
        return AccountBalanceDisplayManager.reverseCredit(accountType, balance);
    }

    public static void setDisplayMode(AccountBalanceDisplayMode newMode) {
        accountBalanceDisplayingMode = newMode;
        Preferences p = Preferences.userNodeForPackage(AccountBalanceDisplayManager.class);
        p.putInt(ACCOUNT_BALANCE_DISPLAY_MODE, accountBalanceDisplayingMode.getValue());
        AccountBalanceDisplayManager.accountBalanceDisplayModeChanged();
    }

    public static AccountBalanceDisplayMode getDisplayMode() {
        return accountBalanceDisplayingMode;
    }

    public static void addAccountBalanceDisplayModeChangeListener(ActionListener actionListener) {
        actionListeners.add(new WeakReference<ActionListener>(actionListener));
    }

    private static void accountBalanceDisplayModeChanged() {
        Iterator<WeakReference<ActionListener>> iterator = actionListeners.iterator();
        while (iterator.hasNext()) {
            WeakReference<ActionListener> reference = iterator.next();
            ActionListener actionListener = (ActionListener)reference.get();
            if (actionListener != null) {
                ActionEvent e = new ActionEvent(actionListener, 1001, "AccountBalanceChanged");
                actionListener.actionPerformed(e);
                continue;
            }
            iterator.remove();
        }
    }

    static {
        actionListeners = new ArrayList<WeakReference<ActionListener>>();
        Preferences p = Preferences.userNodeForPackage(AccountBalanceDisplayManager.class);
        accountBalanceDisplayingMode = AccountBalanceDisplayMode.createFromInt(p.getInt(ACCOUNT_BALANCE_DISPLAY_MODE, AccountBalanceDisplayMode.NONE.getValue()));
    }
}

