/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.awt.EventQueue;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.swing.table.AbstractTableModel;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.message.ChannelEvent;
import jgnash.message.Message;
import jgnash.message.MessageBus;
import jgnash.message.MessageChannel;
import jgnash.message.MessageListener;
import jgnash.message.MessageProperty;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.ui.register.table.AccountTableModel;
import jgnash.ui.register.table.PackableTableModel;
import jgnash.util.BigDecimalCache;
import jgnash.util.Resource;

public abstract class AbstractRegisterTableModel
extends AbstractTableModel
implements MessageListener,
AccountTableModel,
PackableTableModel {
    private static final long serialVersionUID = 1545319678064522849L;
    static final Resource rb = Resource.get();
    Account account;
    BigDecimalCache balanceCache;
    private String[] cNames;
    private Class<?>[] cClass;
    String reconcileSymbol = "\u2713";
    static final String ERROR = "error";
    boolean[] columnVisible;
    private int[] columnMap;
    private boolean columnCountCache = false;
    private int columnCount;
    private int[] columnWidths = null;

    AbstractRegisterTableModel(Account account, String[] names, Class<?>[] clazz) {
        assert (account != null);
        this.init(account, names, clazz);
    }

    @Override
    public int[] getPreferredColumnWeights() {
        return (int[])this.columnWidths.clone();
    }

    public void setPreferredColumnWeights(int[] widths) {
        this.columnWidths = (int[])widths.clone();
    }

    private void init(Account a, String[] names, Class<?>[] clazz) {
        this.cNames = Arrays.copyOf(names, names.length);
        this.cClass = Arrays.copyOf(clazz, clazz.length);
        this.account = a;
        this.balanceCache = new BigDecimalCache(a.getTransactionCount());
        MessageBus.getInstance().registerListener(this, MessageChannel.COMMODITY, MessageChannel.TRANSACTION, MessageChannel.SYSTEM);
        this.columnVisible = new boolean[this.cNames.length];
        Arrays.fill(this.columnVisible, true);
        this.buildColumnMap();
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    public String[] getColumnNames() {
        return this.cNames;
    }

    protected abstract Object getInternalValueAt(int var1, int var2);

    private void setColumnVisible(int col, boolean visible) {
        if (visible != this.columnVisible[col]) {
            this.columnVisible[col] = visible;
            this.buildColumnMap();
            this.fireTableStructureChanged();
        }
    }

    public void setColumnVisible(String name, boolean visible) {
        for (int i = 0; i < this.cNames.length; ++i) {
            if (!this.cNames[i].equals(name)) continue;
            this.setColumnVisible(i, visible);
        }
    }

    public void setColumnVisibility(boolean[] array) {
        if (array != null && array.length == this.columnVisible.length) {
            this.columnVisible = (boolean[])array.clone();
            this.buildColumnMap();
            this.fireTableStructureChanged();
            this.columnCountCache = false;
        }
    }

    public boolean isColumnVisible(int col) {
        return this.columnVisible[col];
    }

    public boolean[] getColumnVisibility() {
        return this.columnVisible;
    }

    void buildColumnMap() {
        int index = 0;
        this.columnMap = new int[this.getColumnCount()];
        for (int i = 0; i < this.columnVisible.length; ++i) {
            if (!this.columnVisible[i]) continue;
            this.columnMap[index] = i;
            ++index;
        }
    }

    int getColumnMapping(int col) {
        return this.columnMap[col];
    }

    @Override
    public int getRowCount() {
        return this.account.getTransactionCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.cNames[this.columnMap[col]];
    }

    @Override
    public int getColumnCount() {
        if (this.columnCountCache) {
            return this.columnCount;
        }
        this.columnCount = 0;
        for (boolean aColumnVisible : this.columnVisible) {
            if (!aColumnVisible) continue;
            ++this.columnCount;
        }
        return this.columnCount;
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.cClass[this.columnMap[col]];
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.getInternalValueAt(row, this.columnMap[col]);
    }

    @Override
    public void messagePosted(final Message event) {
        if (event.getEvent() == ChannelEvent.CURRENCY_MODIFY) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractRegisterTableModel.this.fireTableDataChanged();
                }
            });
        }
        if (this.account.equals(event.getObject(MessageProperty.ACCOUNT))) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    switch (event.getEvent()) {
                        case FILE_CLOSING: {
                            AbstractRegisterTableModel.this.unregister();
                            return;
                        }
                        case TRANSACTION_ADD: {
                            Transaction t = (Transaction)event.getObject(MessageProperty.TRANSACTION);
                            int index = AbstractRegisterTableModel.this.account.indexOf(t);
                            AbstractRegisterTableModel.this.balanceCache.ensureCapacity(AbstractRegisterTableModel.this.account.getTransactionCount());
                            AbstractRegisterTableModel.this.balanceCache.clear(index);
                            AbstractRegisterTableModel.this.fireTableRowsInserted(index, index);
                            break;
                        }
                        case TRANSACTION_REMOVE: {
                            AbstractRegisterTableModel.this.balanceCache.clear();
                            AbstractRegisterTableModel.this.fireTableDataChanged();
                            break;
                        }
                    }
                }
            });
        }
    }

    void unregister() {
        MessageBus.getInstance().unregisterListener(this, MessageChannel.SYSTEM, MessageChannel.TRANSACTION);
        this.balanceCache.trimToSize(0);
        this.account = null;
    }

    public Transaction getTransactionAt(int index) {
        return this.account.getTransactionAt(index);
    }

    public int indexOf(Transaction t) {
        return this.account.indexOf(t);
    }

    BigDecimal getBalanceAt(int index) {
        if (this.balanceCache.get(index) != null) {
            return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), this.balanceCache.get(index));
        }
        BigDecimal balance = this.account.getBalanceAt(index);
        this.balanceCache.set(index, balance);
        return AccountBalanceDisplayManager.convertToSelectedBalanceMode(this.account.getAccountType(), balance);
    }

    public void setReconcileSymbol(String reconcileSymbol) {
        this.reconcileSymbol = reconcileSymbol;
    }
}

