/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.register.table;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TableModelListener;
import jgnash.engine.Account;
import jgnash.engine.Transaction;
import jgnash.engine.search.PayeeMatcher;
import jgnash.ui.register.table.AbstractRegisterTableModel;
import jgnash.ui.register.table.FilterModel;

public class FilterDecorator
implements FilterModel {
    private AbstractRegisterTableModel model;
    private String filter;
    private PayeeMatcher pm;
    private List<Integer> matchedPayee;

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
        this.pm = new PayeeMatcher(filter, false);
        this.updateMatches();
    }

    private void updateMatches() {
        this.matchedPayee.clear();
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            Transaction t = this.model.getTransactionAt(i);
            if (!this.pm.matches(t)) continue;
            this.matchedPayee.add(i);
        }
    }

    public FilterDecorator(AbstractRegisterTableModel model) {
        this.model = model;
        this.filter = "*";
        this.pm = new PayeeMatcher(this.filter, false);
        this.matchedPayee = new ArrayList<Integer>();
        this.updateMatches();
    }

    @Override
    public void setReconcileSymbol(String reconcileSymbol) {
        this.model.setReconcileSymbol(reconcileSymbol);
    }

    @Override
    public int[] getPreferredColumnWeights() {
        return this.model.getPreferredColumnWeights();
    }

    @Override
    public Account getAccount() {
        return this.model.getAccount();
    }

    @Override
    public int getRowCount() {
        return this.matchedPayee.size();
    }

    @Override
    public int getColumnCount() {
        return this.model.getColumnCount();
    }

    @Override
    public String getColumnName(int col) {
        return this.model.getColumnName(col);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return this.model.getColumnClass(col);
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return this.model.isCellEditable(arg0, arg1);
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.model.getValueAt(this.matchedPayee.get(row), col);
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
        this.model.setValueAt(arg0, arg1, arg2);
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.model.addTableModelListener(arg0);
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
        this.model.removeTableModelListener(arg0);
    }

    @Override
    public void setColumnVisible(String name, boolean visible) {
        this.model.setColumnVisible(name, visible);
    }
}

