/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.report.compiled;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileNameExtensionFilter;
import jgnash.engine.Account;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.RootAccount;
import jgnash.ui.components.DatePanel;
import jgnash.ui.register.AccountBalanceDisplayManager;
import jgnash.util.DateUtils;
import jgnash.util.Resource;

public final class MonthBalanceCSV {
    private static final boolean SHOW_EMPTY_ACCOUNT = false;
    private ArrayList<Account> accounts = new ArrayList();
    private ArrayList<BigDecimal[]> balance = new ArrayList();
    private SimpleDateFormat df = new SimpleDateFormat("MMMMM");
    private final Resource rb = Resource.get();
    private boolean vertical = true;

    private MonthBalanceCSV() {
        Date[] dates = this.getDates();
        if (dates != null) {
            Engine engine = EngineFactory.getEngine("default");
            RootAccount root = engine.getRootAccount();
            this.buildLists(root, dates);
            try {
                System.out.println("writing file");
                if (this.vertical) {
                    this.writeCSVFileVert(this.getFileName(), dates);
                } else {
                    this.writeCSVFileHoriz(this.getFileName(), dates);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Date[] getDates() {
        DatePanel startField = new DatePanel();
        DatePanel endField = new DatePanel();
        ButtonGroup group = new ButtonGroup();
        JRadioButton vert = new JRadioButton(this.rb.getString("Button.Vertical"));
        JRadioButton horiz = new JRadioButton(this.rb.getString("Button.Horizontal"));
        group.add(vert);
        group.add(horiz);
        vert.setSelected(true);
        FormLayout layout = new FormLayout("right:p, 4dlu, p:g", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setRowGroupingEnabled(true);
        builder.append(this.rb.getString("Label.StartDate"), (Component)startField);
        builder.append(this.rb.getString("Label.EndDate"), (Component)endField);
        builder.append(this.rb.getString("Label.Layout"), (Component)vert);
        builder.append("", (Component)horiz);
        builder.nextLine();
        builder.appendUnrelatedComponentsGapRow();
        builder.nextLine();
        JPanel panel = builder.getPanel();
        int option = JOptionPane.showConfirmDialog(null, new Object[]{panel}, this.rb.getString("Message.StartEndDate"), 2, -1);
        Date[] dates = option == 0 ? MonthBalanceCSV.getLastDays(startField.getDate(), endField.getDate()) : null;
        this.vertical = vert.isSelected();
        return dates;
    }

    private static Date[] getLastDays(Date start, Date stop) {
        ArrayList<Date> list = new ArrayList<Date>();
        Date s = DateUtils.trimDate(start);
        Calendar c = Calendar.getInstance();
        c.setTime(s);
        c.set(5, 15);
        Date t = DateUtils.getLastDayOfTheMonth(c.get(2), c.get(1));
        while (DateUtils.before(t, stop)) {
            list.add(t);
            c.setTime(t);
            c.add(2, 1);
            t = DateUtils.getLastDayOfTheMonth(c.get(2), c.get(1));
        }
        return list.toArray(new Date[list.size()]);
    }

    private void buildLists(Account a, Date[] dates) {
        for (Account child : a.getChildren()) {
            int len = child.getTransactionCount();
            if (len > 0) {
                this.accounts.add(child);
                BigDecimal[] b = new BigDecimal[dates.length];
                for (int j = 0; j < dates.length; ++j) {
                    b[j] = AccountBalanceDisplayManager.convertToSelectedBalanceMode(child.getAccountType(), child.getBalance(dates[j]));
                }
                this.balance.add(b);
            }
            if (!child.isParent()) continue;
            this.buildLists(child, dates);
        }
    }

    private void writeCSVFileHoriz(String fileName, Date[] dates) throws IOException {
        if (fileName == null || dates == null) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
        int length = this.accounts.size();
        for (Account a : this.accounts) {
            writer.write(",");
            writer.write(a.getPathName());
        }
        writer.newLine();
        for (int i = 0; i < dates.length; ++i) {
            writer.write(this.df.format(dates[i]));
            for (int j = 0; j < length; ++j) {
                BigDecimal[] b = this.balance.get(j);
                writer.write(",");
                writer.write(b[i].toString());
            }
            writer.newLine();
        }
        writer.close();
    }

    private void writeCSVFileVert(String fileName, Date[] dates) throws IOException {
        if (fileName == null || dates == null) {
            return;
        }
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fileName)));
        for (Date date : dates) {
            writer.write(",");
            writer.write(this.df.format(date));
        }
        writer.newLine();
        for (int i = 0; i < this.accounts.size(); ++i) {
            BigDecimal[] b;
            writer.write(this.accounts.get(i).getPathName());
            for (BigDecimal aB : b = this.balance.get(i)) {
                writer.write(",");
                writer.write(aB.toString());
            }
            writer.newLine();
        }
        writer.close();
    }

    String getFileName() {
        JFileChooser chooser = new JFileChooser();
        chooser.setMultiSelectionEnabled(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter(this.rb.getString("Message.CSVFile"), "csv"));
        if (chooser.showSaveDialog(null) == 0) {
            String fileName = chooser.getSelectedFile().getAbsolutePath();
            if (!fileName.endsWith(".csv")) {
                fileName = fileName + ".csv";
            }
            return fileName;
        }
        return null;
    }

    public static void run() {
        new MonthBalanceCSV();
    }
}

