/*
 * Decompiled with CFR 0.152.
 */
package jgnash.ui.wizards.file;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.StyledEditorKit;
import jgnash.engine.CurrencyNode;
import jgnash.ui.components.SortedListModel;
import jgnash.ui.components.wizard.WizardPage;
import jgnash.ui.util.TextResource;
import jgnash.ui.wizards.file.NewFileDialog;
import jgnash.util.Resource;

public class NewFileThree
extends JPanel
implements WizardPage,
ActionListener {
    private final Resource rb = Resource.get();
    private JEditorPane helpPane;
    private JList<CurrencyNode> aJList;
    private JButton addButton;
    private JList<CurrencyNode> cJList;
    private JButton removeButton;
    private SortedListModel<CurrencyNode> aList;
    private SortedListModel<CurrencyNode> cList;

    public NewFileThree() {
        this.layoutMainPanel();
    }

    private void initComponents() {
        this.addButton = new JButton(this.rb.getString("Button.Add"));
        this.addButton.setIcon(Resource.getIcon("/jgnash/resource/list-add.png"));
        this.addButton.setHorizontalTextPosition(10);
        this.removeButton = new JButton(this.rb.getString("Button.Remove"));
        this.removeButton.setIcon(Resource.getIcon("/jgnash/resource/list-remove.png"));
        this.aJList = new JList();
        this.cJList = new JList();
        this.helpPane = new JEditorPane();
        this.helpPane.setEditable(false);
        this.helpPane.setEditorKit(new StyledEditorKit());
        this.helpPane.setBackground(this.getBackground());
        this.helpPane.setText(TextResource.getString("NewFileThree.txt"));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent evt) {
                NewFileThree.this.isPageValid();
            }
        });
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
    }

    private void layoutMainPanel() {
        this.initComponents();
        FormLayout layout = new FormLayout("min(65dlu;d):g(0.5), 8dlu, d, 8dlu, min(65dlu;d):g(0.5)", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.appendSeparator(this.rb.getString("Title.SelAvailCurr"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.append((Component)this.helpPane, 5);
        builder.appendTitle(this.rb.getString("Title.Available"));
        builder.append("");
        builder.appendTitle(this.rb.getString("Title.Selected"));
        builder.nextLine();
        builder.appendRelatedComponentsGapRow();
        builder.nextLine();
        builder.appendRow(RowSpec.decode((String)"f:d:g"));
        builder.append((Component)new JScrollPane(this.aJList), (Component)this.buildCenterPanel(), (Component)new JScrollPane(this.cJList));
    }

    private JPanel buildCenterPanel() {
        FormLayout layout = new FormLayout("d", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.append((Component)this.addButton);
        builder.append((Component)this.removeButton);
        return builder.getPanel();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.addButton) {
            this.addAction();
        } else if (e.getSource() == this.removeButton) {
            this.removeAction();
        }
    }

    private void removeAction() {
        CurrencyNode obj = this.cJList.getSelectedValue();
        if (obj != null) {
            this.cList.removeElement(obj);
            this.aList.addElement(obj);
        }
    }

    private void addAction() {
        CurrencyNode obj = this.aJList.getSelectedValue();
        if (obj != null) {
            this.aList.removeElement(obj);
            this.cList.addElement(obj);
        }
    }

    @Override
    public boolean isPageValid() {
        return true;
    }

    @Override
    public String toString() {
        return "3. " + this.rb.getString("Title.SelAvailCurr");
    }

    @Override
    public void getSettings(Map<Enum<?>, Object> map) {
        if (this.aList == null) {
            Set currencies = (Set)map.get((Object)NewFileDialog.Settings.DEFAULT_CURRENCIES);
            this.aList = new SortedListModel(currencies);
            this.cList = new SortedListModel();
            this.aJList.setModel(this.aList);
            this.cJList.setModel(this.cList);
        }
    }

    @Override
    public void putSettings(Map<Enum<?>, Object> map) {
        map.put(NewFileDialog.Settings.CURRENCIES, new TreeSet<CurrencyNode>(this.cList.asList()));
    }
}

