/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountUtils;
import jgnash.engine.CommodityNode;
import jgnash.engine.CurrencyNode;
import jgnash.engine.Engine;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;

public class AccountTreeXMLFactory {
    private static XStream getStream() {
        XStream xstream = new XStream((ReflectionProvider)new PureJavaReflectionProvider(), (HierarchicalStreamDriver)new StaxDriver());
        xstream.setMode(1002);
        xstream.alias("Account", Account.class);
        xstream.alias("RootAccount", RootAccount.class);
        xstream.alias("CurrencyNode", CurrencyNode.class);
        xstream.alias("SecurityNode", SecurityNode.class);
        xstream.useAttributeFor(Account.class, "placeHolder");
        xstream.useAttributeFor(Account.class, "locked");
        xstream.useAttributeFor(Account.class, "visible");
        xstream.useAttributeFor(Account.class, "name");
        xstream.useAttributeFor(Account.class, "description");
        xstream.useAttributeFor(CommodityNode.class, "symbol");
        xstream.useAttributeFor(CommodityNode.class, "scale");
        xstream.useAttributeFor(CommodityNode.class, "prefix");
        xstream.useAttributeFor(CommodityNode.class, "suffix");
        xstream.useAttributeFor(CommodityNode.class, "description");
        xstream.omitField(StoredObject.class, "uuid");
        xstream.omitField(StoredObject.class, "markedForRemoval");
        xstream.omitField(Account.class, "transactions");
        xstream.omitField(Account.class, "accountBalance");
        xstream.omitField(Account.class, "reconciledBalance");
        xstream.omitField(SecurityNode.class, "historyNodes");
        return xstream;
    }

    public static void exportAccountTree(Engine engine, File file) {
        RootAccount account = engine.getRootAccount();
        XStream xstream = AccountTreeXMLFactory.getStream();
        try {
            ObjectOutputStream out = xstream.createObjectOutputStream((HierarchicalStreamWriter)new PrettyPrintWriter((Writer)new FileWriter(file)));
            out.writeObject(account);
            out.close();
        }
        catch (IOException e) {
            Logger.getLogger(AccountTreeXMLFactory.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
        }
    }

    private static RootAccount loadAccountTree(Reader reader) {
        RootAccount account = null;
        XStream xstream = AccountTreeXMLFactory.getStream();
        try {
            ObjectInputStream in = xstream.createObjectInputStream(reader);
            Object o = in.readObject();
            in.close();
            if (o instanceof RootAccount) {
                account = (RootAccount)o;
            }
        }
        catch (IOException | ClassNotFoundException ex) {
            Logger.getLogger(AccountTreeXMLFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return account;
    }

    public static RootAccount loadAccountTree(File file) {
        RootAccount account = null;
        try {
            account = AccountTreeXMLFactory.loadAccountTree(new FileReader(file));
        }
        catch (IOException ex) {
            Logger.getLogger(AccountTreeXMLFactory.class.getName()).log(Level.SEVERE, null, ex);
        }
        return account;
    }

    public static RootAccount loadAccountTree(InputStream stream) {
        return AccountTreeXMLFactory.loadAccountTree(new InputStreamReader(stream));
    }

    public static void importAccountTree(Engine engine, RootAccount root) {
        AccountImport accountImport = new AccountImport();
        accountImport.importAccountTree(engine, root);
    }

    public static void mergeAccountTree(Engine engine, RootAccount root) {
        AccountImport accountImport = new AccountImport();
        accountImport.mergeAccountTree(engine, root);
    }

    private AccountTreeXMLFactory() {
    }

    private static class AccountImport {
        private Map<Account, Account> mergeMap = new HashMap<Account, Account>();

        private AccountImport() {
        }

        private void importAccountTree(Engine engine, RootAccount root) {
            this.forceCurrency(engine, root);
            for (Account child : root.getChildren()) {
                this.importChildren(engine, child);
            }
        }

        private void mergeAccountTree(Engine engine, RootAccount root) {
            this.fixCurrencies(engine, root);
            for (Account child : root.getChildren()) {
                this.importChildren(engine, child);
            }
        }

        private void fixCurrencies(Engine engine, Account account) {
            for (CurrencyNode currencyNode : engine.getCurrencies()) {
                if (!account.getCurrencyNode().matches(currencyNode)) continue;
                account.setCurrencyNode(currencyNode);
            }
            if (account.memberOf(AccountGroup.INVEST)) {
                Set<SecurityNode> nodes = account.getSecurities();
                for (SecurityNode node : nodes) {
                    SecurityNode sNode = engine.getSecurity(node.getSymbol());
                    if (sNode == null) {
                        try {
                            sNode = (SecurityNode)node.clone();
                            for (CurrencyNode currencyNode : engine.getCurrencies()) {
                                if (!sNode.getReportedCurrencyNode().matches(currencyNode)) continue;
                                sNode.setReportedCurrencyNode(currencyNode);
                            }
                            engine.addCommodity(sNode);
                        }
                        catch (CloneNotSupportedException e) {
                            Logger.getLogger(AccountTreeXMLFactory.class.getName()).log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                    account.removeSecurity(node);
                    account.addSecurity(sNode);
                }
            }
            for (Account child : account.getChildren()) {
                this.fixCurrencies(engine, child);
            }
        }

        private void forceCurrency(Engine engine, Account account) {
            account.setCurrencyNode(engine.getDefaultCurrency());
            if (account.memberOf(AccountGroup.INVEST)) {
                Set<SecurityNode> nodes = account.getSecurities();
                for (SecurityNode node : nodes) {
                    SecurityNode sNode = engine.getSecurity(node.getSymbol());
                    if (sNode == null) {
                        try {
                            sNode = (SecurityNode)node.clone();
                            sNode.setReportedCurrencyNode(engine.getDefaultCurrency());
                            engine.addCommodity(sNode);
                        }
                        catch (CloneNotSupportedException e) {
                            Logger.getLogger(AccountTreeXMLFactory.class.getName()).log(Level.SEVERE, e.toString(), e);
                        }
                    }
                    account.removeSecurity(node);
                    account.addSecurity(sNode);
                }
            }
            for (Account child : account.getChildren()) {
                this.forceCurrency(engine, child);
            }
        }

        private void importChildren(Engine engine, Account account) {
            Account match;
            if (account.getParent() instanceof RootAccount) {
                this.mergeMap.put(account.getParent(), engine.getRootAccount());
            }
            if ((match = AccountUtils.searchTree(engine.getRootAccount(), account.getName(), account.getAccountType(), account.getDepth())) != null && match.getParent().equals(this.mergeMap.get(account.getParent()))) {
                this.mergeMap.put(account, match);
            } else {
                this.mergeMap.put(account, account);
                Account parent = this.mergeMap.get(account.getParent());
                engine.addAccount(parent, account);
            }
            for (Account child : account.getChildren()) {
                this.importChildren(engine, child);
            }
        }
    }
}

