/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.AccountGroup;
import jgnash.engine.AccountProxy;
import jgnash.engine.InvestmentAccountProxy;
import jgnash.util.Resource;

public enum AccountType {
    ASSET(Resource.get().getString("AccountType.Asset"), AccountGroup.ASSET, AccountProxy.class, true),
    BANK(Resource.get().getString("AccountType.Bank"), AccountGroup.ASSET, AccountProxy.class, true),
    CASH(Resource.get().getString("AccountType.Cash"), AccountGroup.ASSET, AccountProxy.class, true),
    CHECKING(Resource.get().getString("AccountType.Checking"), AccountGroup.ASSET, AccountProxy.class, true),
    CREDIT(Resource.get().getString("AccountType.Credit"), AccountGroup.LIABILITY, AccountProxy.class, true),
    EQUITY(Resource.get().getString("AccountType.Equity"), AccountGroup.EQUITY, AccountProxy.class, true),
    EXPENSE(Resource.get().getString("AccountType.Expense"), AccountGroup.EXPENSE, AccountProxy.class, true),
    INCOME(Resource.get().getString("AccountType.Income"), AccountGroup.INCOME, AccountProxy.class, true),
    INVEST(Resource.get().getString("AccountType.Investment"), AccountGroup.INVEST, InvestmentAccountProxy.class, false),
    LIABILITY(Resource.get().getString("AccountType.Liability"), AccountGroup.LIABILITY, AccountProxy.class, true),
    MUTUAL(Resource.get().getString("AccountType.Mutual"), AccountGroup.INVEST, InvestmentAccountProxy.class, false),
    ROOT(Resource.get().getString("AccountType.Root"), AccountGroup.ROOT, AccountProxy.class, true);

    private final transient String description;
    private final transient AccountGroup accountGroup;
    private final transient Class<? extends AccountProxy> accountProxy;
    private final transient boolean mutable;

    private AccountType(String description, AccountGroup accountGroup, Class<? extends AccountProxy> accountProxy, boolean mutable) {
        this.description = description;
        this.accountGroup = accountGroup;
        this.accountProxy = accountProxy;
        this.mutable = mutable;
    }

    public static Set<AccountType> getAccountTypes(AccountGroup group) {
        Set<AccountType> list = AccountType.getAccountTypeSet();
        Iterator<AccountType> i = list.iterator();
        while (i.hasNext()) {
            if (i.next().getAccountGroup() == group) continue;
            i.remove();
        }
        return list;
    }

    public String toString() {
        return this.description;
    }

    public AccountGroup getAccountGroup() {
        return this.accountGroup;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public static Set<AccountType> getAccountTypeSet() {
        EnumSet<AccountType> set = EnumSet.allOf(AccountType.class);
        set.remove((Object)ROOT);
        return set;
    }

    AccountProxy getProxy(Account account) {
        try {
            Class[] constParams = new Class[]{Account.class};
            Constructor<? extends AccountProxy> accConst = this.accountProxy.getDeclaredConstructor(constParams);
            Object[] params = new Object[]{account};
            return accConst.newInstance(params);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            Logger.getLogger(AccountType.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

