/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine;

import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Currency;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.CurrencyNode;

public class DefaultCurrencies {
    private DefaultCurrencies() {
    }

    public static Set<CurrencyNode> generateCurrencies() {
        TreeSet<CurrencyNode> set = new TreeSet<CurrencyNode>();
        for (Locale locale : NumberFormat.getAvailableLocales()) {
            if (locale.getCountry().length() != 2) continue;
            try {
                if (Currency.getInstance(locale) == null) continue;
                set.add(DefaultCurrencies.buildNode(locale));
            }
            catch (Exception ex) {
                Logger.getLogger(DefaultCurrencies.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CurrencyNode buildCustomNode(String ISOCode) {
        CurrencyNode node = new CurrencyNode();
        try {
            Currency c = Currency.getInstance(ISOCode);
            node.setSymbol(c.getCurrencyCode());
        }
        catch (Exception e) {
            node.setSymbol(ISOCode);
        }
        finally {
            node.setDescription(Locale.getDefault().toString());
        }
        return node;
    }

    public static CurrencyNode buildNode(Locale locale) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        Currency c = symbols.getCurrency();
        CurrencyNode node = new CurrencyNode();
        node.setSymbol(c.getCurrencyCode());
        node.setPrefix(symbols.getCurrencySymbol());
        node.setScale((byte)c.getDefaultFractionDigits());
        return node;
    }
}

