/*
 * Decompiled with CFR 0.152.
 */
package jgnash.engine.xstream;

import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Account;
import jgnash.engine.CommodityNode;
import jgnash.engine.Config;
import jgnash.engine.CurrencyNode;
import jgnash.engine.ExchangeRate;
import jgnash.engine.ExchangeRateHistoryNode;
import jgnash.engine.InvestmentTransaction;
import jgnash.engine.RootAccount;
import jgnash.engine.SecurityHistoryNode;
import jgnash.engine.SecurityNode;
import jgnash.engine.StoredObject;
import jgnash.engine.Transaction;
import jgnash.engine.TransactionEntry;
import jgnash.engine.TransactionEntryAddX;
import jgnash.engine.TransactionEntryBuyX;
import jgnash.engine.TransactionEntryDividendX;
import jgnash.engine.TransactionEntryMergeX;
import jgnash.engine.TransactionEntryReinvestDivX;
import jgnash.engine.TransactionEntryRemoveX;
import jgnash.engine.TransactionEntrySellX;
import jgnash.engine.TransactionEntrySplitX;
import jgnash.engine.budget.Budget;
import jgnash.engine.budget.BudgetGoal;
import jgnash.engine.budget.BudgetPeriod;
import jgnash.engine.xstream.XMLContainer;

public abstract class AbstractXStreamContainer {
    protected final List<StoredObject> objects = new ArrayList<StoredObject>();
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock(true);
    protected final File file;
    private FileLock fileLock = null;
    private FileChannel lockChannel = null;

    public AbstractXStreamContainer(File file) {
        this.file = file;
    }

    protected static <T extends StoredObject> List<T> query(Collection<StoredObject> values, Class<T> clazz) {
        ArrayList<StoredObject> list = new ArrayList<StoredObject>();
        for (StoredObject o : values) {
            if (!clazz.isAssignableFrom(o.getClass())) continue;
            list.add(o);
        }
        return list;
    }

    public static XStream configureXStream(XStream xstream) {
        xstream.setMode(1002);
        xstream.alias("Account", Account.class);
        xstream.alias("RootAccount", RootAccount.class);
        xstream.alias("Budget", Budget.class);
        xstream.alias("BudgetGoal", BudgetGoal.class);
        xstream.alias("Config", Config.class);
        xstream.alias("CurrencyNode", CurrencyNode.class);
        xstream.alias("ExchangeRate", ExchangeRate.class);
        xstream.alias("ExchangeRateHistoryNode", ExchangeRateHistoryNode.class);
        xstream.alias("InvestmentTransaction", InvestmentTransaction.class);
        xstream.alias("BudgetPeriod", BudgetPeriod.class);
        xstream.alias("SecurityNode", SecurityNode.class);
        xstream.alias("SecurityHistoryNode", SecurityHistoryNode.class);
        xstream.alias("Transaction", Transaction.class);
        xstream.alias("TransactionEntry", TransactionEntry.class);
        xstream.alias("TransactionEntryAddX", TransactionEntryAddX.class);
        xstream.alias("TransactionEntryBuyX", TransactionEntryBuyX.class);
        xstream.alias("TransactionEntryDividendX", TransactionEntryDividendX.class);
        xstream.alias("TransactionEntryMergeX", TransactionEntryMergeX.class);
        xstream.alias("TransactionEntryReinvestDivX", TransactionEntryReinvestDivX.class);
        xstream.alias("TransactionEntryRemoveX", TransactionEntryRemoveX.class);
        xstream.alias("TransactionEntrySellX", TransactionEntrySellX.class);
        xstream.alias("TransactionEntrySplitX", TransactionEntrySplitX.class);
        xstream.useAttributeFor(Account.class, "placeHolder");
        xstream.useAttributeFor(Account.class, "locked");
        xstream.useAttributeFor(Account.class, "visible");
        xstream.useAttributeFor(Account.class, "name");
        xstream.useAttributeFor(Account.class, "description");
        xstream.useAttributeFor(Budget.class, "description");
        xstream.useAttributeFor(Budget.class, "name");
        xstream.useAttributeFor(CommodityNode.class, "symbol");
        xstream.useAttributeFor(CommodityNode.class, "scale");
        xstream.useAttributeFor(CommodityNode.class, "prefix");
        xstream.useAttributeFor(CommodityNode.class, "suffix");
        xstream.useAttributeFor(CommodityNode.class, "description");
        xstream.useAttributeFor(SecurityHistoryNode.class, "date");
        xstream.useAttributeFor(SecurityHistoryNode.class, "price");
        xstream.useAttributeFor(SecurityHistoryNode.class, "high");
        xstream.useAttributeFor(SecurityHistoryNode.class, "low");
        xstream.useAttributeFor(SecurityHistoryNode.class, "volume");
        xstream.useAttributeFor(StoredObject.class, "uuid");
        xstream.omitField(StoredObject.class, "markedForRemoval");
        return xstream;
    }

    protected boolean acquireFileLock() {
        try {
            this.lockChannel = new RandomAccessFile(this.file, "rw").getChannel();
            this.fileLock = this.lockChannel.tryLock();
            return true;
        }
        catch (IOException | OverlappingFileLockException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
            return false;
        }
    }

    protected void releaseFileLock() {
        try {
            if (this.fileLock != null) {
                this.fileLock.release();
                this.fileLock = null;
            }
            if (this.lockChannel != null) {
                this.lockChannel.close();
                this.lockChannel = null;
            }
        }
        catch (IOException ex) {
            Logger.getLogger(XMLContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    abstract void commit();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean set(StoredObject object) {
        boolean result = false;
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            if (this.get(object.getUuid()) == null) {
                this.objects.add(object);
            }
            result = true;
        }
        finally {
            l.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete(StoredObject object) {
        Lock l = this.readWriteLock.writeLock();
        l.lock();
        try {
            this.objects.remove(object);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StoredObject get(String uuid) {
        StoredObject result = null;
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            for (StoredObject o : this.objects) {
                if (!o.getUuid().equals(uuid)) continue;
                result = o;
            }
        }
        finally {
            l.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T extends StoredObject> List<T> query(Class<T> clazz) {
        List<T> list = null;
        Lock l = this.readWriteLock.readLock();
        l.lock();
        try {
            list = AbstractXStreamContainer.query(this.objects, clazz);
        }
        finally {
            l.unlock();
        }
        return list;
    }

    void close() {
        this.releaseFileLock();
    }

    String getFileName() {
        if (this.file != null) {
            return this.file.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<StoredObject> asList() {
        ArrayList<StoredObject> list = null;
        this.readWriteLock.readLock().lock();
        try {
            list = new ArrayList<StoredObject>(this.objects);
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return list;
    }
}

