/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import jgnash.engine.Engine;
import jgnash.engine.EngineFactory;
import jgnash.engine.StoredObject;
import jgnash.message.ChannelEvent;
import jgnash.message.MessageChannel;
import jgnash.message.MessageProperty;

public class Message
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2351895771349706585L;
    private ChannelEvent event;
    private MessageChannel channel;
    private String source;
    private String message = "";
    private transient EnumMap<MessageProperty, StoredObject> properties = new EnumMap(MessageProperty.class);
    private transient boolean remote;

    @Deprecated
    public Message() {
    }

    public Message(MessageChannel channel, ChannelEvent event, Engine source) {
        this(channel, event, source.getUuid());
    }

    private Message(MessageChannel channel, ChannelEvent event, String source) {
        if (source == null || event == null || channel == null) {
            throw new IllegalArgumentException();
        }
        this.source = source;
        this.event = event;
        this.channel = channel;
    }

    public MessageChannel getChannel() {
        return this.channel;
    }

    public ChannelEvent getEvent() {
        return this.event;
    }

    public void setMessage(String message) {
        if (message == null) {
            throw new IllegalArgumentException("data may not be null");
        }
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public void setObject(MessageProperty key, StoredObject value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException("value may not be null");
        }
        this.properties.put(key, value);
    }

    public Object getObject(MessageProperty key) {
        return this.properties.get((Object)key);
    }

    public String getSource() {
        return this.source;
    }

    public void setRemote(boolean remote) {
        this.remote = remote;
    }

    public boolean isRemote() {
        return this.remote;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeUTF(this.message);
        s.writeInt(this.properties.size());
        StoredObject[] values = this.properties.values().toArray(new StoredObject[this.properties.size()]);
        MessageProperty[] keys = this.properties.keySet().toArray(new MessageProperty[this.properties.size()]);
        for (int i = 0; i < this.properties.size(); ++i) {
            s.writeObject((Object)keys[i]);
            s.writeUTF(values[i].getUuid());
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.message = s.readUTF();
        this.properties = new EnumMap(MessageProperty.class);
        int size = s.readInt();
        Engine engine = EngineFactory.getEngine("default");
        for (int i = 0; i < size; ++i) {
            MessageProperty key = (MessageProperty)((Object)s.readObject());
            StoredObject value = engine.getStoredObjectByUuid(s.readUTF());
            this.properties.put(key, value);
        }
    }

    public Message clone() throws CloneNotSupportedException {
        Message m = null;
        try {
            m = (Message)super.clone();
            m.message = this.message;
            m.properties = this.properties.clone();
        }
        catch (CloneNotSupportedException e) {
            Logger.getLogger(Message.class.getName()).log(Level.SEVERE, e.toString(), e);
        }
        return m;
    }

    public String toString() {
        return String.format("Message [event=%s, channel=%s, source=%s \n\tmessage=%s]", new Object[]{this.event, this.channel, this.source, this.message});
    }
}

