/*
 * Decompiled with CFR 0.152.
 */
package jgnash.message;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.locks.ReentrantLock;
import jgnash.message.Message;
import jgnash.message.MessageListener;

public class MessageProxy {
    private final List<WeakReference<MessageListener>> messageListeners = new ArrayList<WeakReference<MessageListener>>();
    private final ReentrantLock lock = new ReentrantLock();
    private static final ExecutorService THREAD_POOL = Executors.newCachedThreadPool();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addMessageListener(MessageListener messageListener) {
        this.lock.lock();
        try {
            this.messageListeners.add(new WeakReference<MessageListener>(messageListener));
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeMessageListener(MessageListener messageListener) {
        this.lock.lock();
        try {
            Iterator<WeakReference<MessageListener>> iterator = this.messageListeners.iterator();
            while (iterator.hasNext()) {
                WeakReference<MessageListener> reference = iterator.next();
                MessageListener actionListener = (MessageListener)reference.get();
                if (actionListener != null && actionListener != messageListener) continue;
                iterator.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forwardMessage(final Message message) {
        this.lock.lock();
        try {
            THREAD_POOL.submit(new Runnable(){

                @Override
                public void run() {
                    Iterator iterator = MessageProxy.this.messageListeners.iterator();
                    while (iterator.hasNext()) {
                        WeakReference reference = (WeakReference)iterator.next();
                        final MessageListener actionListener = (MessageListener)reference.get();
                        if (actionListener != null) {
                            THREAD_POOL.submit(new Runnable(){

                                @Override
                                public void run() {
                                    actionListener.messagePosted(message);
                                }
                            });
                            continue;
                        }
                        iterator.remove();
                    }
                }
            });
        }
        finally {
            this.lock.unlock();
        }
    }
}

