/*
 * Decompiled with CFR 0.152.
 */
package jgnash.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.prefs.Preferences;

public class ConnectionFactory {
    private static final String TIMEOUT = "timeout";

    private ConnectionFactory() {
    }

    public static synchronized void setConnectionTimeout(int seconds) {
        if (seconds < 1 || seconds > 120) {
            throw new IllegalArgumentException("Invalid timeout connection");
        }
        Preferences pref = Preferences.userNodeForPackage(ConnectionFactory.class);
        pref.putInt(TIMEOUT, seconds);
    }

    public static synchronized int getConnectionTimeout() {
        Preferences pref = Preferences.userNodeForPackage(ConnectionFactory.class);
        return pref.getInt(TIMEOUT, 30);
    }

    public static synchronized URLConnection getConnection(String url) {
        URLConnection connection = null;
        try {
            connection = ConnectionFactory.getConnection(new URL(url));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return connection;
    }

    private static synchronized URLConnection getConnection(URL url) {
        URLConnection connection = null;
        try {
            connection = url.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (connection != null) {
            connection.setConnectTimeout(ConnectionFactory.getConnectionTimeout() * 1000);
            connection.setReadTimeout(ConnectionFactory.getConnectionTimeout() * 1000);
        }
        return connection;
    }
}

