/*
 * Decompiled with CFR 0.152.
 */
package EDU.purdue.cs.bloat.tree;

import EDU.purdue.cs.bloat.editor.Type;
import EDU.purdue.cs.bloat.tree.Expr;
import EDU.purdue.cs.bloat.tree.TreeVisitor;

public class ArithExpr
extends Expr {
    char operation;
    Expr left;
    Expr right;
    public static final char ADD = '+';
    public static final char SUB = '-';
    public static final char DIV = '/';
    public static final char MUL = '*';
    public static final char REM = '%';
    public static final char AND = '&';
    public static final char IOR = '|';
    public static final char XOR = '^';
    public static final char CMP = '?';
    public static final char CMPL = '<';
    public static final char CMPG = '>';

    public ArithExpr(char operation, Expr left, Expr right, Type type) {
        super(type);
        this.operation = operation;
        this.left = left;
        this.right = right;
        left.setParent(this);
        right.setParent(this);
    }

    public int operation() {
        return this.operation;
    }

    public Expr left() {
        return this.left;
    }

    public Expr right() {
        return this.right;
    }

    public void visitForceChildren(TreeVisitor visitor) {
        if (visitor.reverse()) {
            this.right.visit(visitor);
            this.left.visit(visitor);
        } else {
            this.left.visit(visitor);
            this.right.visit(visitor);
        }
    }

    public void visit(TreeVisitor visitor) {
        visitor.visitArithExpr(this);
    }

    public int exprHashCode() {
        return '\u0001' + this.operation ^ this.left.exprHashCode() ^ this.right.exprHashCode();
    }

    public boolean equalsExpr(Expr other) {
        return other != null && other instanceof ArithExpr && ((ArithExpr)other).operation == this.operation && ((ArithExpr)other).left.equalsExpr(this.left) && ((ArithExpr)other).right.equalsExpr(this.right);
    }

    public Object clone() {
        return this.copyInto(new ArithExpr(this.operation, (Expr)this.left.clone(), (Expr)this.right.clone(), this.type));
    }
}

