/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.tigris.subversion.svnant.SvnCommand;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Mkdir
extends SvnCommand {
    private SVNUrl url = null;
    private File path = null;
    private String message = null;

    public void execute(ISVNClientAdapter iSVNClientAdapter) throws BuildException {
        this.validateAttributes();
        this.log("Svn : Creating a new directory under revision control");
        if (this.url != null) {
            try {
                iSVNClientAdapter.mkdir(this.url, this.message);
            }
            catch (SVNClientException sVNClientException) {
                throw new BuildException("Can't make dir " + this.url, (Throwable)sVNClientException);
            }
        }
        try {
            iSVNClientAdapter.mkdir(this.path);
        }
        catch (SVNClientException sVNClientException) {
            throw new BuildException("Can't make dir " + this.path, (Throwable)sVNClientException);
        }
    }

    protected void validateAttributes() throws BuildException {
        if (this.url == null && this.path == null) {
            throw new BuildException("url or path attributes must be set");
        }
        if (this.url != null && this.path != null) {
            throw new BuildException("Either url or path attributes must be set");
        }
        if (this.url != null && this.message == null) {
            throw new BuildException("Message attribute must be set when url is used");
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

