/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import org.custommonkey.xmlunit.ElementNameQualifier;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class ElementNameAndAttributeQualifier
extends ElementNameQualifier {
    public static final String[] ALL_ATTRIBUTES = new String[]{"*"};
    private final String[] qualifyingAttrNames;

    public ElementNameAndAttributeQualifier() {
        this(ALL_ATTRIBUTES);
    }

    public ElementNameAndAttributeQualifier(String attrName) {
        this(new String[]{attrName});
    }

    public ElementNameAndAttributeQualifier(String[] attrNames) {
        this.qualifyingAttrNames = attrNames;
    }

    public boolean qualifyForComparison(Element control, Element test) {
        if (super.qualifyForComparison(control, test)) {
            return this.areAttributesComparable(control, test);
        }
        return false;
    }

    protected boolean areAttributesComparable(Element control, Element test) {
        int n;
        Attr[] qualifyingAttributes;
        NamedNodeMap namedNodeMap = control.getAttributes();
        if (this.qualifyingAttrNames == ALL_ATTRIBUTES) {
            qualifyingAttributes = new Attr[namedNodeMap.getLength()];
            n = 0;
            while (n < qualifyingAttributes.length) {
                qualifyingAttributes[n] = (Attr)namedNodeMap.item(n);
                ++n;
            }
        } else {
            qualifyingAttributes = new Attr[this.qualifyingAttrNames.length];
            n = 0;
            while (n < this.qualifyingAttrNames.length) {
                qualifyingAttributes[n] = (Attr)namedNodeMap.getNamedItem(this.qualifyingAttrNames[n]);
                ++n;
            }
        }
        int i = 0;
        while (i < qualifyingAttributes.length) {
            String nsURI = qualifyingAttributes[i].getNamespaceURI();
            String controlValue = qualifyingAttributes[i].getNodeValue();
            String testValue = nsURI == null || nsURI.length() == 0 ? test.getAttribute(qualifyingAttributes[i].getName()) : test.getAttributeNS(nsURI, qualifyingAttributes[i].getLocalName());
            if (controlValue == null ? testValue != null : !controlValue.equals(testValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

