/*
 * Decompiled with CFR 0.152.
 */
package org.custommonkey.xmlunit;

import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.custommonkey.xmlunit.XMLUnit;
import org.custommonkey.xmlunit.XSLTConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleXpathEngine
implements XSLTConstants {
    private StringBuffer getXSLTBase() {
        return new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>").append("<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">");
    }

    private String getCopyTransformation(String select) {
        return this.getXSLTBase().append("<xsl:preserve-space elements=\"*\"/>").append("<xsl:output method=\"xml\" version=\"1.0\" encoding=\"UTF-8\"/>").append("<xsl:template match=\"/\">").append("<xpathResult>").append("<xsl:apply-templates select=\"").append(select).append("\" mode=\"result\"/>").append("</xpathResult>").append("</xsl:template>").append("<xsl:template match=\"*\" mode=\"result\">").append("  <xsl:copy-of select=\".\"/>").append("</xsl:template>").append("</xsl:stylesheet>").toString();
    }

    private String getValueTransformation(String select) {
        return this.getXSLTBase().append("<xsl:output method=\"text\"/>").append("<xsl:template match=\"/\">").append("  <xsl:value-of select=\"").append(select).append("\"/>").append("</xsl:template>").append("</xsl:stylesheet>").toString();
    }

    private void performTransform(String xslt, Document document, Result result) throws TransformerConfigurationException, TransformerException {
        StreamSource source = new StreamSource(new StringReader(xslt));
        Transformer transformer = XMLUnit.getTransformerFactory().newTransformer(source);
        transformer.transform(new DOMSource(document), result);
    }

    protected Node getXPathResultNode(String select, Document document) throws TransformerException {
        return this.getXPathResultAsDocument(select, document).getDocumentElement();
    }

    protected Document getXPathResultAsDocument(String select, Document document) throws TransformerException {
        DOMResult result = new DOMResult();
        this.performTransform(this.getCopyTransformation(select), document, result);
        return (Document)result.getNode();
    }

    public NodeList getMatchingNodes(String select, Document document) throws TransformerException, TransformerConfigurationException {
        return this.getXPathResultNode(select, document).getChildNodes();
    }

    public String evaluate(String select, Document document) throws TransformerException, TransformerConfigurationException {
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        this.performTransform(this.getValueTransformation(select), document, result);
        return writer.toString();
    }
}

