/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.layout;

import com.mxgraph.layout.mxGraphLayout;
import com.mxgraph.model.mxGeometry;
import com.mxgraph.model.mxIGraphModel;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.view.mxGraph;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCompactTreeLayout
extends mxGraphLayout {
    protected boolean horizontal;
    protected boolean invert;
    protected boolean resizeParent = true;
    protected boolean moveTree = true;
    protected boolean resetEdges = true;
    protected int levelDistance = 10;
    protected int nodeDistance = 20;

    public mxCompactTreeLayout(mxGraph mxGraph2) {
        this(mxGraph2, true);
    }

    public mxCompactTreeLayout(mxGraph mxGraph2, boolean bl) {
        this(mxGraph2, bl, false);
    }

    public mxCompactTreeLayout(mxGraph mxGraph2, boolean bl, boolean bl2) {
        super(mxGraph2);
        this.horizontal = bl;
        this.invert = bl2;
    }

    @Override
    public boolean isVertexIgnored(Object object) {
        return super.isVertexIgnored(object) || this.graph.getConnections(object).length == 0;
    }

    public boolean isHorizontal() {
        return this.horizontal;
    }

    public void setHorizontal(boolean bl) {
        this.horizontal = bl;
    }

    public boolean isInvert() {
        return this.invert;
    }

    public void setInvert(boolean bl) {
        this.invert = bl;
    }

    public boolean isResizeParent() {
        return this.resizeParent;
    }

    public void setResizeParent(boolean bl) {
        this.resizeParent = bl;
    }

    public boolean isMoveTree() {
        return this.moveTree;
    }

    public void setMoveTree(boolean bl) {
        this.moveTree = bl;
    }

    public boolean isResetEdges() {
        return this.resetEdges;
    }

    public void setResetEdges(boolean bl) {
        this.resetEdges = bl;
    }

    public int getLevelDistance() {
        return this.levelDistance;
    }

    public void setLevelDistance(int n) {
        this.levelDistance = n;
    }

    public int getNodeDistance() {
        return this.nodeDistance;
    }

    public void setNodeDistance(int n) {
        this.nodeDistance = n;
    }

    @Override
    public void execute(Object object) {
        this.execute(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Object object, Object object2) {
        Object[] objectArray;
        mxIGraphModel mxIGraphModel2 = this.graph.getModel();
        if (object2 == null) {
            if (this.graph.getEdges(object, mxIGraphModel2.getParent(object), this.invert, !this.invert, false).length > 0) {
                object2 = object;
            } else {
                objectArray = this.graph.findTreeRoots(object, true, this.invert);
                if (objectArray.length > 0) {
                    for (int i = 0; i < objectArray.length; ++i) {
                        if (this.isVertexIgnored(objectArray[i]) || this.graph.getEdges(objectArray[i], null, this.invert, !this.invert, false).length <= 0) continue;
                        object2 = objectArray[i];
                        break;
                    }
                }
            }
        }
        if (object2 != null) {
            object = mxIGraphModel2.getParent(object2);
            mxIGraphModel2.beginUpdate();
            try {
                objectArray = this.dfs(object2, object, null);
                if (objectArray != null) {
                    mxRectangle mxRectangle2;
                    double d;
                    this.layout((TreeNode)objectArray);
                    double d2 = d = (double)this.graph.getGridSize();
                    if (!(this.moveTree && mxIGraphModel2.getParent(object) != mxIGraphModel2.getRoot() || (mxRectangle2 = mxIGraphModel2.getGeometry(object2)) == null)) {
                        d = mxRectangle2.getX();
                        d2 = mxRectangle2.getY();
                    }
                    mxRectangle2 = null;
                    mxRectangle2 = this.horizontal ? this.horizontalLayout((TreeNode)objectArray, d, d2, null) : this.verticalLayout((TreeNode)objectArray, null, d, d2, null);
                    if (mxRectangle2 != null) {
                        double d3 = 0.0;
                        double d4 = 0.0;
                        if (mxRectangle2.getX() < 0.0) {
                            d3 = Math.abs(d - mxRectangle2.getX());
                        }
                        if (mxRectangle2.getY() < 0.0) {
                            d4 = Math.abs(d2 - mxRectangle2.getY());
                        }
                        if (object != null) {
                            mxGeometry mxGeometry2;
                            mxRectangle mxRectangle3 = this.graph.getStartSize(object);
                            d3 += mxRectangle3.getWidth();
                            d4 += mxRectangle3.getHeight();
                            if (this.resizeParent && !this.graph.isCellCollapsed(object) && (mxGeometry2 = mxIGraphModel2.getGeometry(object)) != null) {
                                double d5 = mxRectangle2.getWidth() + mxRectangle3.getWidth() - mxRectangle2.getX() + 2.0 * d;
                                double d6 = mxRectangle2.getHeight() + mxRectangle3.getHeight() - mxRectangle2.getY() + 2.0 * d2;
                                if ((mxGeometry2 = (mxGeometry)mxGeometry2.clone()).getWidth() > d5) {
                                    d3 += (mxGeometry2.getWidth() - d5) / 2.0;
                                } else {
                                    mxGeometry2.setWidth(d5);
                                }
                                if (mxGeometry2.getHeight() > d6) {
                                    if (this.horizontal) {
                                        d4 += (mxGeometry2.getHeight() - d6) / 2.0;
                                    }
                                } else {
                                    mxGeometry2.setHeight(d6);
                                }
                                mxIGraphModel2.setGeometry(object, mxGeometry2);
                            }
                        }
                        this.moveNode((TreeNode)objectArray, d3, d4);
                    }
                }
            }
            finally {
                mxIGraphModel2.endUpdate();
            }
        }
    }

    protected void moveNode(TreeNode treeNode, double d, double d2) {
        treeNode.x += d;
        treeNode.y += d2;
        this.apply(treeNode, null);
        TreeNode treeNode2 = treeNode.child;
        while (treeNode2 != null) {
            this.moveNode(treeNode2, d, d2);
            treeNode2 = treeNode2.next;
        }
    }

    protected TreeNode dfs(Object object, Object object2, Set<Object> set) {
        if (set == null) {
            set = new HashSet<Object>();
        }
        TreeNode treeNode = null;
        if (object != null && !set.contains(object) && !this.isVertexIgnored(object)) {
            set.add(object);
            treeNode = this.createNode(object);
            mxIGraphModel mxIGraphModel2 = this.graph.getModel();
            TreeNode treeNode2 = null;
            Object[] objectArray = this.graph.getEdges(object, object2, this.invert, !this.invert, false);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3;
                TreeNode treeNode3;
                Object object4 = objectArray[i];
                if (this.isEdgeIgnored(object4)) continue;
                if (this.resetEdges) {
                    this.setEdgePoints(object4, null);
                }
                if ((treeNode3 = this.dfs(object3 = this.graph.getView().getVisibleTerminal(object4, this.invert), object2, set)) == null || mxIGraphModel2.getGeometry(object3) == null) continue;
                if (treeNode2 == null) {
                    treeNode.child = treeNode3;
                } else {
                    treeNode2.next = treeNode3;
                }
                treeNode2 = treeNode3;
            }
        }
        return treeNode;
    }

    protected void layout(TreeNode treeNode) {
        if (treeNode != null) {
            TreeNode treeNode2 = treeNode.child;
            while (treeNode2 != null) {
                this.layout(treeNode2);
                treeNode2 = treeNode2.next;
            }
            if (treeNode.child != null) {
                this.attachParent(treeNode, this.join(treeNode));
            } else {
                this.layoutLeaf(treeNode);
            }
        }
    }

    protected mxRectangle horizontalLayout(TreeNode treeNode, double d, double d2, mxRectangle mxRectangle2) {
        treeNode.x += d + treeNode.offsetX;
        treeNode.y += d2 + treeNode.offsetY;
        mxRectangle2 = this.apply(treeNode, mxRectangle2);
        TreeNode treeNode2 = treeNode.child;
        if (treeNode2 != null) {
            mxRectangle2 = this.horizontalLayout(treeNode2, treeNode.x, treeNode.y, mxRectangle2);
            double d3 = treeNode.y + treeNode2.offsetY;
            TreeNode treeNode3 = treeNode2.next;
            while (treeNode3 != null) {
                mxRectangle2 = this.horizontalLayout(treeNode3, treeNode.x + treeNode2.offsetX, d3, mxRectangle2);
                d3 += treeNode3.offsetY;
                treeNode3 = treeNode3.next;
            }
        }
        return mxRectangle2;
    }

    protected mxRectangle verticalLayout(TreeNode treeNode, Object object, double d, double d2, mxRectangle mxRectangle2) {
        treeNode.x += d + treeNode.offsetY;
        treeNode.y += d2 + treeNode.offsetX;
        mxRectangle2 = this.apply(treeNode, mxRectangle2);
        TreeNode treeNode2 = treeNode.child;
        if (treeNode2 != null) {
            mxRectangle2 = this.verticalLayout(treeNode2, treeNode, treeNode.x, treeNode.y, mxRectangle2);
            double d3 = treeNode.x + treeNode2.offsetY;
            TreeNode treeNode3 = treeNode2.next;
            while (treeNode3 != null) {
                mxRectangle2 = this.verticalLayout(treeNode3, treeNode, d3, treeNode.y + treeNode2.offsetX, mxRectangle2);
                d3 += treeNode3.offsetY;
                treeNode3 = treeNode3.next;
            }
        }
        return mxRectangle2;
    }

    protected void attachParent(TreeNode treeNode, double d) {
        double d2 = this.nodeDistance + this.levelDistance;
        double d3 = (d - treeNode.width) / 2.0 - (double)this.nodeDistance;
        double d4 = d3 + treeNode.width + (double)(2 * this.nodeDistance) - d;
        treeNode.child.offsetX = d2 + treeNode.height;
        treeNode.child.offsetY = d4;
        treeNode.contour.upperHead = this.createLine(treeNode.height, 0.0, this.createLine(d2, d4, treeNode.contour.upperHead));
        treeNode.contour.lowerHead = this.createLine(treeNode.height, 0.0, this.createLine(d2, d3, treeNode.contour.lowerHead));
    }

    protected void layoutLeaf(TreeNode treeNode) {
        double d = 2 * this.nodeDistance;
        treeNode.contour.upperHead = treeNode.contour.upperTail = this.createLine(treeNode.height + d, 0.0, null);
        treeNode.contour.lowerTail = this.createLine(0.0, -treeNode.width - d, null);
        treeNode.contour.lowerHead = this.createLine(treeNode.height + d, 0.0, treeNode.contour.lowerTail);
    }

    protected double join(TreeNode treeNode) {
        double d;
        double d2 = 2 * this.nodeDistance;
        TreeNode treeNode2 = treeNode.child;
        treeNode.contour = treeNode2.contour;
        double d3 = d = treeNode2.width + d2;
        treeNode2 = treeNode2.next;
        while (treeNode2 != null) {
            double d4 = this.merge(treeNode.contour, treeNode2.contour);
            treeNode2.offsetY = d4 + d;
            treeNode2.offsetX = 0.0;
            d = treeNode2.width + d2;
            d3 += d4 + d;
            treeNode2 = treeNode2.next;
        }
        return d3;
    }

    protected double merge(Polygon polygon, Polygon polygon2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        Polyline polyline = polygon.lowerHead;
        Polyline polyline2 = polygon2.upperHead;
        while (polyline2 != null && polyline != null) {
            double d4 = this.offset(d, d2, polyline2.dx, polyline2.dy, polyline.dx, polyline.dy);
            d2 += d4;
            d3 += d4;
            if (d + polyline2.dx <= polyline.dx) {
                d += polyline2.dx;
                d2 += polyline2.dy;
                polyline2 = polyline2.next;
                continue;
            }
            d -= polyline.dx;
            d2 -= polyline.dy;
            polyline = polyline.next;
        }
        if (polyline2 != null) {
            Polyline polyline3 = this.bridge(polygon.upperTail, 0.0, 0.0, polyline2, d, d2);
            polygon.upperTail = polyline3.next != null ? polygon2.upperTail : polyline3;
            polygon.lowerTail = polygon2.lowerTail;
        } else {
            Polyline polyline4 = this.bridge(polygon2.lowerTail, d, d2, polyline, 0.0, 0.0);
            if (polyline4.next == null) {
                polygon.lowerTail = polyline4;
            }
        }
        polygon.lowerHead = polygon2.lowerHead;
        return d3;
    }

    protected double offset(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = 0.0;
        if (d5 <= d || d + d3 <= 0.0) {
            return 0.0;
        }
        double d8 = d5 * d4 - d3 * d6;
        if (d8 > 0.0) {
            if (d < 0.0) {
                double d9 = d * d4;
                d7 = d9 / d3 - d2;
            } else if (d > 0.0) {
                double d10 = d * d6;
                d7 = d10 / d5 - d2;
            } else {
                d7 = -d2;
            }
        } else if (d5 < d + d3) {
            double d11 = (d5 - d) * d4;
            d7 = d6 - (d2 + d11 / d3);
        } else if (d5 > d + d3) {
            double d12 = (d3 + d) * d6;
            d7 = d12 / d5 - (d2 + d4);
        } else {
            d7 = d6 - (d2 + d4);
        }
        if (d7 > 0.0) {
            return d7;
        }
        return 0.0;
    }

    protected Polyline bridge(Polyline polyline, double d, double d2, Polyline polyline2, double d3, double d4) {
        double d5 = d3 + polyline2.dx - d;
        double d6 = 0.0;
        double d7 = 0.0;
        if (polyline2.dx == 0.0) {
            d6 = polyline2.dy;
        } else {
            d7 = d5 * polyline2.dy;
            d6 = d7 / polyline2.dx;
        }
        Polyline polyline3 = this.createLine(d5, d6, polyline2.next);
        polyline.next = this.createLine(0.0, d4 + polyline2.dy - d6 - d2, polyline3);
        return polyline3;
    }

    protected TreeNode createNode(Object object) {
        TreeNode treeNode = new TreeNode(object);
        mxRectangle mxRectangle2 = this.getVertexBounds(object);
        if (mxRectangle2 != null) {
            if (this.horizontal) {
                treeNode.width = mxRectangle2.getHeight();
                treeNode.height = mxRectangle2.getWidth();
            } else {
                treeNode.width = mxRectangle2.getWidth();
                treeNode.height = mxRectangle2.getHeight();
            }
        }
        return treeNode;
    }

    protected mxRectangle apply(TreeNode treeNode, mxRectangle mxRectangle2) {
        mxRectangle mxRectangle3 = this.graph.getModel().getGeometry(treeNode.cell);
        if (treeNode.cell != null && mxRectangle3 != null) {
            if (this.isVertexMovable(treeNode.cell)) {
                mxRectangle3 = this.setVertexLocation(treeNode.cell, treeNode.x, treeNode.y);
            }
            mxRectangle2 = mxRectangle2 == null ? new mxRectangle(mxRectangle3.getX(), mxRectangle3.getY(), mxRectangle3.getWidth(), mxRectangle3.getHeight()) : new mxRectangle(Math.min(mxRectangle2.getX(), mxRectangle3.getX()), Math.min(mxRectangle2.getY(), mxRectangle3.getY()), Math.max(mxRectangle2.getX() + mxRectangle2.getWidth(), mxRectangle3.getX() + mxRectangle3.getWidth()), Math.max(mxRectangle2.getY() + mxRectangle2.getHeight(), mxRectangle3.getY() + mxRectangle3.getHeight()));
        }
        return mxRectangle2;
    }

    protected Polyline createLine(double d, double d2, Polyline polyline) {
        return new Polyline(d, d2, polyline);
    }

    protected static class Polyline {
        protected double dx;
        protected double dy;
        protected Polyline next;

        protected Polyline(double d, double d2, Polyline polyline) {
            this.dx = d;
            this.dy = d2;
            this.next = polyline;
        }
    }

    protected static class Polygon {
        protected Polyline lowerHead;
        protected Polyline lowerTail;
        protected Polyline upperHead;
        protected Polyline upperTail;

        protected Polygon() {
        }
    }

    protected static class TreeNode {
        protected Object cell;
        protected double x;
        protected double y;
        protected double width;
        protected double height;
        protected double offsetX;
        protected double offsetY;
        protected TreeNode child;
        protected TreeNode next;
        protected Polygon contour = new Polygon();

        public TreeNode(Object object) {
            this.cell = object;
        }
    }
}

