/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.swing.handler;

import com.mxgraph.swing.handler.mxCellHandler;
import com.mxgraph.swing.mxGraphComponent;
import com.mxgraph.swing.util.mxMouseControl;
import com.mxgraph.util.mxEventObject;
import com.mxgraph.util.mxEventSource;
import com.mxgraph.view.mxCellState;
import com.mxgraph.view.mxGraph;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.SwingUtilities;

public class mxSubHandler
extends mxMouseControl {
    private static final long serialVersionUID = -882368002120921842L;
    public static int DEFAULT_MAX_HANDLERS = 100;
    protected mxGraphComponent graphComponent;
    protected int maxHandlers = DEFAULT_MAX_HANDLERS;
    protected transient Map<Object, mxCellHandler> handlers = new LinkedHashMap<Object, mxCellHandler>();
    protected transient mxEventSource.mxIEventListener refreshHandler = new mxEventSource.mxIEventListener(){

        public void invoke(Object object, mxEventObject mxEventObject2) {
            mxSubHandler.this.refresh();
        }
    };

    public mxSubHandler(mxGraphComponent mxGraphComponent2) {
        this.graphComponent = mxGraphComponent2;
        mxGraphComponent2.getGraphControl().add((Component)this, 0);
        mxGraphComponent2.getGraphControl().addMouseListener(this);
        mxGraphComponent2.getGraphControl().addMouseMotionListener(this);
        mxGraphComponent2.getGraph().getSelectionModel().addListener("change", this.refreshHandler);
        mxGraphComponent2.getGraph().addListener("repaint", this.refreshHandler);
        mxGraphComponent2.getGraph().addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("vertexLabelsMovable") || propertyChangeEvent.getPropertyName().equals("edgeLabelsMovable")) {
                    mxSubHandler.this.refresh();
                }
            }
        });
        mxGraphComponent.mxMouseRedirector mxMouseRedirector2 = new mxGraphComponent.mxMouseRedirector(mxGraphComponent2);
        this.addMouseMotionListener(mxMouseRedirector2);
        this.addMouseListener(mxMouseRedirector2);
    }

    public mxGraphComponent getGraphComponent() {
        return this.graphComponent;
    }

    public int getMaxHandlers() {
        return this.maxHandlers;
    }

    public void setMaxHandlers(int n) {
        this.maxHandlers = n;
    }

    public mxCellHandler getHandler(Object object) {
        return this.handlers.get(object);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && !this.graphComponent.isForceMarqueeEvent(mouseEvent) && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mousePressed(mouseEvent);
            }
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseMoved(mouseEvent);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseDragged(mouseEvent);
            }
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.graphComponent.isEnabled() && this.isEnabled()) {
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext() && !mouseEvent.isConsumed()) {
                iterator.next().mouseReleased(mouseEvent);
            }
        }
        this.reset();
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, this.graphComponent.getGraphControl());
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        String string = null;
        while (iterator.hasNext() && string == null) {
            string = iterator.next().getToolTipText(mouseEvent2);
        }
        if (string == null || string.length() == 0) {
            string = this.graphComponent.getGraphControl().getToolTipText(mouseEvent2);
        }
        return string;
    }

    public void reset() {
        Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().reset();
        }
    }

    public void refresh() {
        mxGraph mxGraph2 = this.graphComponent.getGraph();
        Map<Object, mxCellHandler> map = this.handlers;
        this.handlers = new LinkedHashMap<Object, mxCellHandler>();
        Object[] objectArray = mxGraph2.getSelectionCells();
        boolean bl = objectArray.length <= this.getMaxHandlers();
        Rectangle rectangle = null;
        for (int i = 0; i < objectArray.length; ++i) {
            mxCellState mxCellState2 = mxGraph2.getView().getState(objectArray[i]);
            if (mxCellState2 == null) continue;
            mxCellHandler mxCellHandler2 = map.get(objectArray[i]);
            if (mxCellHandler2 != null) {
                mxCellHandler2.refresh(mxCellState2);
            } else {
                mxCellHandler2 = this.graphComponent.createHandler(mxCellState2);
            }
            if (mxCellHandler2 == null) continue;
            mxCellHandler2.setHandlesVisible(bl);
            this.handlers.put(objectArray[i], mxCellHandler2);
            if (rectangle == null) {
                rectangle = mxCellHandler2.getBounds();
                continue;
            }
            rectangle.add(mxCellHandler2.getBounds());
        }
        this.setVisible(!this.handlers.isEmpty());
        if (this.isVisible()) {
            if (rectangle != null) {
                rectangle.grow(1, 1);
                this.setBounds(rectangle);
            } else {
                this.setBounds(this.graphComponent.getViewport().getVisibleRect());
            }
            this.repaint();
        }
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.isVisible()) {
            graphics.translate(-this.getX(), -this.getY());
            Iterator<mxCellHandler> iterator = this.handlers.values().iterator();
            while (iterator.hasNext()) {
                iterator.next().paint(graphics);
            }
            graphics.translate(this.getX(), this.getY());
        }
    }
}

