/*
 * Decompiled with CFR 0.152.
 */
package com.mxgraph.shape;

import com.mxgraph.canvas.mxGraphics2DCanvas;
import com.mxgraph.shape.mxITextShape;
import com.mxgraph.util.mxConstants;
import com.mxgraph.util.mxCurve;
import com.mxgraph.util.mxLine;
import com.mxgraph.util.mxPoint;
import com.mxgraph.util.mxRectangle;
import com.mxgraph.util.mxUtils;
import com.mxgraph.view.mxCellState;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class mxCurveLabelShape
implements mxITextShape {
    protected String lastValue;
    protected Font lastFont;
    protected List<mxPoint> lastPoints;
    protected mxCurve curve;
    protected mxCellState state;
    protected LabelGlyphCache[] labelGlyphs;
    protected double labelSize;
    protected mxRectangle labelBounds;
    protected LabelPosition labelPosition = new LabelPosition();
    public static double LABEL_BUFFER = 30.0;
    protected boolean rotationEnabled = true;

    public mxCurveLabelShape(mxCellState mxCellState2, mxCurve mxCurve2) {
        this.state = mxCellState2;
        this.curve = mxCurve2;
    }

    public boolean getRotationEnabled() {
        return this.rotationEnabled;
    }

    public void setRotationEnabled(boolean bl) {
        this.rotationEnabled = bl;
    }

    @Override
    public void paintShape(mxGraphics2DCanvas mxGraphics2DCanvas2, String string, mxCellState mxCellState2, Map<String, Object> map) {
        Rectangle rectangle = mxCellState2.getLabelBounds().getRectangle();
        Graphics2D graphics2D = mxGraphics2DCanvas2.getGraphics();
        if (this.labelGlyphs == null) {
            this.updateLabelBounds(string, map);
        }
        if (this.labelGlyphs != null && (graphics2D.getClipBounds() == null || graphics2D.getClipBounds().intersects(rectangle))) {
            float f = mxUtils.getFloat(map, mxConstants.STYLE_OPACITY, 100.0f);
            Graphics2D graphics2D2 = graphics2D;
            graphics2D = mxGraphics2DCanvas2.createTemporaryGraphics(map, f, mxCellState2);
            Font font = mxUtils.getFont(map, mxGraphics2DCanvas2.getScale());
            graphics2D.setFont(font);
            Color color = mxUtils.getColor(map, mxConstants.STYLE_FONTCOLOR, Color.black);
            graphics2D.setColor(color);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            for (int i = 0; i < string.length(); ++i) {
                mxLine mxLine2 = this.labelGlyphs[i].glyphVector;
                double d = Math.atan(mxLine2.getEndPoint().getY() / mxLine2.getEndPoint().getX());
                AffineTransform affineTransform = graphics2D.getTransform();
                graphics2D.translate(mxLine2.getX(), mxLine2.getY());
                graphics2D.rotate(d);
                graphics2D.drawString(string.substring(i, i + 1), 0.0f, 0.0f);
                graphics2D.setTransform(affineTransform);
            }
            graphics2D.dispose();
            graphics2D = graphics2D2;
        }
    }

    public mxRectangle updateLabelBounds(String string, Map<String, Object> map) {
        double d = this.state.getView().getScale();
        Font font = mxUtils.getFont(map, d);
        if (this.labelGlyphs == null || string.length() != this.labelGlyphs.length) {
            this.labelGlyphs = new LabelGlyphCache[string.length()];
        }
        this.labelSize = 0.0;
        FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
        for (int i = 0; i < string.length(); ++i) {
            String string2 = string.substring(i, i + 1);
            mxRectangle mxRectangle2 = new mxRectangle(font.getStringBounds(string2, fontRenderContext));
            if (this.labelGlyphs[i] == null) {
                this.labelGlyphs[i] = new LabelGlyphCache();
            }
            this.labelGlyphs[i].labelGlyphBounds = mxRectangle2;
            this.labelSize += mxRectangle2.getWidth();
            this.labelGlyphs[i].glyph = string2;
        }
        this.lastValue = string;
        this.lastFont = font;
        this.lastPoints = this.curve.getGuidePoints();
        this.labelPosition.startBuffer = LABEL_BUFFER * d;
        this.labelPosition.endBuffer = LABEL_BUFFER * d;
        this.calculationLabelPosition(map, string);
        if (this.curve.isLabelReversed()) {
            double d2 = this.labelPosition.startBuffer;
            this.labelPosition.startBuffer = this.labelPosition.endBuffer;
            this.labelPosition.endBuffer = d2;
        }
        double d3 = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double d4 = this.labelPosition.startBuffer / d3;
        mxRectangle mxRectangle3 = null;
        for (int i = 0; i < string.length(); ++i) {
            mxLine mxLine2;
            this.labelGlyphs[i].glyphVector = mxLine2 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, d4);
            this.labelGlyphs[i].labelGlyphBounds.setX(mxLine2.getX());
            this.labelGlyphs[i].labelGlyphBounds.setY(mxLine2.getY());
            this.postprocessGlyph(this.curve, i, d4);
            d4 += (this.labelGlyphs[i].labelGlyphBounds.getWidth() + this.labelPosition.defaultInterGlyphSpace) / d3;
            if (mxRectangle3 == null) {
                mxRectangle3 = (mxRectangle)this.labelGlyphs[i].labelGlyphBounds.clone();
                continue;
            }
            mxRectangle3.add(this.labelGlyphs[i].labelGlyphBounds);
        }
        if (mxRectangle3 == null) {
            mxLine mxLine3 = this.curve.getCurveParallel(mxCurve.LABEL_CURVE, 0.5);
            mxRectangle3 = new mxRectangle(mxLine3.getX(), mxLine3.getY(), 1.0, 1.0);
        }
        this.labelBounds = mxRectangle3;
        return mxRectangle3;
    }

    protected void postprocessGlyph(mxCurve mxCurve2, int n, double d) {
    }

    public boolean intersectsRect(mxRectangle mxRectangle2) {
        if (this.labelBounds != null && !this.labelBounds.getRectangle().intersects(mxRectangle2.getRectangle())) {
            return false;
        }
        for (int i = 0; i < this.labelGlyphs.length; ++i) {
            if (!mxRectangle2.getRectangle().intersects(this.labelGlyphs[i].labelGlyphBounds.getRectangle())) continue;
            return true;
        }
        return false;
    }

    protected void calculationLabelPosition(Map<String, Object> map, String string) {
        double d = this.curve.getCurveLength(mxCurve.LABEL_CURVE);
        double d2 = d - this.labelPosition.startBuffer - this.labelPosition.endBuffer;
        this.labelPosition.startBuffer = Math.max(this.labelPosition.startBuffer, this.labelPosition.startBuffer + d2 / 2.0 - this.labelSize / 2.0);
        this.labelPosition.endBuffer = Math.max(this.labelPosition.endBuffer, this.labelPosition.endBuffer + d2 / 2.0 - this.labelSize / 2.0);
    }

    public mxCurve getCurve() {
        return this.curve;
    }

    public void setCurve(mxCurve mxCurve2) {
        this.curve = mxCurve2;
    }

    public class LabelPosition {
        public double startBuffer = LABEL_BUFFER;
        public double endBuffer = LABEL_BUFFER;
        public double defaultInterGlyphSpace = 0.0;
    }

    public class LabelGlyphCache {
        public mxRectangle labelGlyphBounds;
        public String glyph;
        public mxLine glyphVector;
    }
}

