/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.aclib.image.ico;

import java.util.HashMap;
import java.util.Map;

public final class TypeCompression {
    private static final Map TYPES;
    public static final TypeCompression BI_RGB;
    public static final TypeCompression BI_RLE8;
    public static final TypeCompression BI_RLE4;
    public static final TypeCompression BI_BITFIELDS;
    private final int _value;
    private final String _name;
    private final String _comment;

    static {
        BI_RGB = new TypeCompression("BI_RGB", 0, "Uncompressed (any BPP)");
        BI_RLE8 = new TypeCompression("BI_RLE8", 1, "8 Bit RLE Compression (8 BPP only)");
        BI_RLE4 = new TypeCompression("BI_RLE4", 2, "4 Bit RLE Compression (4 BPP only)");
        BI_BITFIELDS = new TypeCompression("BI_BITFIELDS", 3, "Uncompressed (16 & 32 BPP only)");
        TYPES = new HashMap();
        TypeCompression.register(BI_RGB);
        TypeCompression.register(BI_RLE8);
        TypeCompression.register(BI_RLE4);
        TypeCompression.register(BI_BITFIELDS);
    }

    private TypeCompression(String string, int n, String string2) {
        this._name = string;
        this._value = n;
        this._comment = string2;
    }

    private static void register(TypeCompression typeCompression) {
        TYPES.put(new Long(typeCompression.getValue()), typeCompression);
    }

    public String toString() {
        return String.valueOf(this._name) + " (" + this._comment + ")";
    }

    public String getName() {
        return this._name;
    }

    public int getValue() {
        return this._value;
    }

    public static TypeCompression getType(long l) {
        TypeCompression typeCompression = (TypeCompression)TYPES.get(new Long(l));
        if (typeCompression == null) {
            throw new IllegalArgumentException("Compression type " + l + " unknown");
        }
        return typeCompression;
    }
}

